/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.media.AbstractImageUploadImpl;

class PlixiUpload
extends AbstractImageUploadImpl {
    public PlixiUpload(Configuration conf, String apiKey, OAuthAuthorization oauth) {
        super(conf, apiKey, oauth);
        logger.warn("Lockerz is no longer providing API.");
        this.uploadUrl = "http://api.plixi.com/api/upload.aspx";
    }

    protected String postUpload() throws TwitterException {
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 201) {
            throw new TwitterException("Plixi image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        if (response.contains("<Error><ErrorCode>")) {
            String error = response.substring(response.indexOf("<ErrorCode>") + "<ErrorCode>".length(), response.lastIndexOf("</ErrorCode>"));
            throw new TwitterException("Plixi image upload failed with this error message: " + error, this.httpResponse);
        }
        if (response.contains("<Status>OK</Status>")) {
            return response.substring(response.indexOf("<MediaUrl>") + "<MediaUrl>".length(), response.indexOf("</MediaUrl>"));
        }
        throw new TwitterException("Unknown Plixi response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader("https://api.twitter.com/1.1/account/verify_credentials.json");
        this.headers.put("X-Auth-Service-Provider", "https://api.twitter.com/1.1/account/verify_credentials.json");
        this.headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
        if (null == this.apiKey) {
            throw new IllegalStateException("No API Key for Plixi specified. put media.providerAPIKey in twitter4j.properties.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("api_key", this.apiKey), this.image};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

