/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import java.util.Collection;
import java.util.Set;
import javax.measure.Measurable;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javolution.util.FastSet;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinatesConverter;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public abstract class CoordinateReferenceSystem<C extends Coordinates<?>>
implements org.opengis.referencing.crs.CoordinateReferenceSystem {
    static final FastSet<String> EMPTY_SET = new FastSet();

    public <T extends Coordinates<?>> CoordinatesConverter<C, T> getConverterTo(CoordinateReferenceSystem<T> that) {
        return new GeneralConverter(that);
    }

    protected abstract C coordinatesOf(AbsolutePosition var1);

    protected abstract AbsolutePosition positionOf(C var1, AbsolutePosition var2);

    @Override
    public abstract CoordinateSystem getCoordinateSystem();

    @Override
    public Extent getValidArea() {
        return null;
    }

    @Override
    public InternationalString getScope() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Identifier getName() {
        return new Name(this.getClass().getName());
    }

    @Override
    public Collection<String> getAlias() {
        return EMPTY_SET;
    }

    @Override
    public Set<String> getIdentifiers() {
        return EMPTY_SET;
    }

    @Override
    public InternationalString getRemarks() {
        return null;
    }

    @Override
    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    static class Name
    implements Identifier {
        final String _value;

        public Name(String value) {
            this._value = value;
        }

        @Override
        public String getCode() {
            return this._value;
        }

        @Override
        public Citation getAuthority() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }

    static class Axis
    implements CoordinateSystemAxis {
        private final Name _name;
        private final String _abbreviation;
        private final Unit<?> _unit;
        private final AxisDirection _direction;

        public Axis(String name, String abbreviation, Unit<?> unit, AxisDirection direction) {
            this._name = new Name(name);
            this._abbreviation = abbreviation;
            this._unit = unit;
            this._direction = direction;
        }

        @Override
        public final Identifier getName() {
            return this._name;
        }

        @Override
        public final String getAbbreviation() {
            return this._abbreviation;
        }

        @Override
        public final Unit<?> getUnit() {
            return this._unit;
        }

        @Override
        public final AxisDirection getDirection() {
            return this._direction;
        }

        @Override
        public Collection<String> getAlias() {
            return EMPTY_SET;
        }

        @Override
        public Set<String> getIdentifiers() {
            return EMPTY_SET;
        }

        @Override
        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private class GeneralConverter<T extends Coordinates<?>>
    implements CoordinatesConverter<C, T> {
        private final CoordinateReferenceSystem<T> _toCRS;

        private GeneralConverter(CoordinateReferenceSystem<T> toCRS) {
            this._toCRS = toCRS;
        }

        @Override
        public T convert(C source) {
            AbsolutePosition position = CoordinateReferenceSystem.this.positionOf(source, new AbsolutePosition());
            return this._toCRS.coordinatesOf(position);
        }
    }

    protected static class AbsolutePosition {
        public Measurable<Angle> latitudeWGS84;
        public Measurable<Angle> longitudeWGS84;
        public Measurable<Length> heightWGS84;
        public Measurable<Duration> timeUTC;

        protected AbsolutePosition() {
        }
    }
}

