/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import java.util.Collection;
import java.util.Set;
import org.jscience.geography.coordinates.CompoundCoordinates;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public class CompoundCRS<C1 extends Coordinates<?>, C2 extends Coordinates<?>>
extends CoordinateReferenceSystem<CompoundCoordinates<C1, C2>> {
    final CoordinateReferenceSystem<C1> _first;
    final CoordinateReferenceSystem<C2> _next;
    final CoordinateSystem _coordinateSystem = new CoordinateSystem(){

        @Override
        public int getDimension() {
            return CompoundCRS.this._first.getCoordinateSystem().getDimension() + CompoundCRS.this._next.getCoordinateSystem().getDimension();
        }

        @Override
        public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
            int firstDimension = CompoundCRS.this._first.getCoordinateSystem().getDimension();
            return dimension < firstDimension ? CompoundCRS.this._first.getCoordinateSystem().getAxis(dimension) : CompoundCRS.this._next.getCoordinateSystem().getAxis(dimension - firstDimension);
        }

        @Override
        public Identifier getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> getAlias() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        @Override
        public Set<String> getIdentifiers() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        @Override
        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    };

    public CompoundCRS(CoordinateReferenceSystem<C1> first, CoordinateReferenceSystem<C2> next) {
        this._first = first;
        this._next = next;
    }

    @Override
    protected CompoundCoordinates<C1, C2> coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
        C1 c1 = this._first.coordinatesOf(position);
        C2 c2 = this._next.coordinatesOf(position);
        return CompoundCoordinates.valueOf(c1, c2);
    }

    @Override
    protected CoordinateReferenceSystem.AbsolutePosition positionOf(CompoundCoordinates<C1, C2> coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
        CoordinateReferenceSystem.AbsolutePosition firstPosition = this._first.positionOf(coordinates.getFirst(), position);
        return this._next.positionOf(coordinates.getNext(), firstPosition);
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this._coordinateSystem;
    }
}

