/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import java.util.Map;
import javolution.context.Context;
import javolution.util.FastCollection;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentContext
extends Context {
    private static PersistentContext _PersistentContext = new PersistentContext();
    private final FastMap _idToValue = new FastMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrent(PersistentContext persistentContext) {
        _PersistentContext = persistentContext;
        FastMap fastMap = Reference.INSTANCES;
        synchronized (fastMap) {
            FastCollection.Record record = Reference.INSTANCES.head();
            FastMap.Entry entry = Reference.INSTANCES.tail();
            while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                Reference reference = (Reference)((FastMap.Entry)record).getValue();
                if (!persistentContext._idToValue.containsKey(reference._id)) continue;
                reference.set(persistentContext._idToValue.get(reference._id));
            }
        }
    }

    public static PersistentContext getCurrent() {
        return _PersistentContext;
    }

    public Map<String, Object> getIdToValue() {
        return this._idToValue;
    }

    @Override
    protected void enterAction() {
        throw new UnsupportedOperationException("Cannot enter persistent context (already in)");
    }

    @Override
    protected void exitAction() {
        throw new UnsupportedOperationException("Cannot exit persistent context (always in)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference<T>
    implements javolution.lang.Reference<T> {
        private static final FastMap INSTANCES = new FastMap();
        private final String _id;
        private T _value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reference(String string, T t) {
            this._id = string;
            this._value = t;
            FastMap fastMap = INSTANCES;
            synchronized (fastMap) {
                if (INSTANCES.containsKey(string)) {
                    throw new IllegalArgumentException("Identifier " + string + " already in use");
                }
                INSTANCES.put(string, this);
            }
            if (_PersistentContext._idToValue.containsKey(string)) {
                this.set(_PersistentContext._idToValue.get(string));
            }
        }

        @Override
        public T get() {
            return this._value;
        }

        @Override
        public void set(T t) {
            this._value = t;
            this.notifyChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMinimum(T t) {
            Reference reference = this;
            synchronized (reference) {
                if (t instanceof Comparable) {
                    T t2 = this.get();
                    if (((Comparable)t).compareTo(t2) > 0) {
                        this.set(t);
                    }
                } else if (t instanceof Integer) {
                    T t3 = this.get();
                    if ((Integer)t > (Integer)t3) {
                        this.set(t);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaximum(T t) {
            Reference reference = this;
            synchronized (reference) {
                if (t instanceof Comparable) {
                    T t2 = this.get();
                    if (((Comparable)t).compareTo(t2) < 0) {
                        this.set(t);
                    }
                } else if (t instanceof Integer) {
                    T t3 = this.get();
                    if ((Integer)t < (Integer)t3) {
                        this.set(t);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }

        protected void notifyChange() {
        }
    }
}

