/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.measure.converter.AddConverter;
import javax.measure.converter.ConversionException;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.UnitFormat;

public abstract class Unit<Q extends Quantity>
implements Serializable {
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    static final HashMap<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected Unit() {
    }

    public abstract Unit<? super Q> getStandardUnit();

    public abstract UnitConverter toStandardUnit();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isStandardUnit() {
        return this.getStandardUnit().equals(this);
    }

    public final boolean isCompatible(Unit<?> that) {
        return this == that || this.getStandardUnit().equals(that.getStandardUnit()) || this.getDimension().equals(that.getDimension());
    }

    public final <T extends Quantity> Unit<T> asType(Class<T> type) throws ClassCastException {
        Dimension dim1 = this.getDimension();
        Unit u = null;
        try {
            u = (Unit)type.getField("UNIT").get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        Dimension dim2 = u.getDimension();
        if (!dim1.equals(dim2)) {
            throw new ClassCastException();
        }
        return this;
    }

    public final Dimension getDimension() {
        Unit<Q> systemUnit = this.getStandardUnit();
        if (systemUnit instanceof BaseUnit) {
            return Dimension.getModel().getDimension((BaseUnit)systemUnit);
        }
        if (systemUnit instanceof AlternateUnit) {
            return ((AlternateUnit)systemUnit).getParent().getDimension();
        }
        ProductUnit productUnit = (ProductUnit)systemUnit;
        Dimension dimension = Dimension.NONE;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            Dimension d = unit.getDimension().pow(productUnit.getUnitPow(i)).root(productUnit.getUnitRoot(i));
            dimension = dimension.times(d);
        }
        return dimension;
    }

    public final UnitConverter getConverterTo(Unit<?> that) throws ConversionException {
        Unit<?> thatSystemUnit;
        if (this.equals(that)) {
            return UnitConverter.IDENTITY;
        }
        Unit<Q> thisSystemUnit = this.getStandardUnit();
        if (thisSystemUnit.equals(thatSystemUnit = that.getStandardUnit())) {
            return that.toStandardUnit().inverse().concatenate(this.toStandardUnit());
        }
        if (!thisSystemUnit.getDimension().equals(thatSystemUnit.getDimension())) {
            throw new ConversionException(this + " is not compatible with " + that);
        }
        UnitConverter thisTransform = this.toStandardUnit().concatenate(Unit.transformOf(this.getBaseUnits()));
        UnitConverter thatTransform = that.toStandardUnit().concatenate(Unit.transformOf(super.getBaseUnits()));
        return thatTransform.inverse().concatenate(thisTransform);
    }

    private Unit<?> getBaseUnits() {
        Unit<Q> systemUnit = this.getStandardUnit();
        if (systemUnit instanceof BaseUnit) {
            return systemUnit;
        }
        if (systemUnit instanceof AlternateUnit) {
            return super.getBaseUnits();
        }
        if (systemUnit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)systemUnit;
            Unit<Quantity> baseUnits = ONE;
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                Unit<Object> unit = super.getBaseUnits();
                unit = unit.pow(productUnit.getUnitPow(i));
                unit = unit.root(productUnit.getUnitRoot(i));
                baseUnits = baseUnits.times(unit);
            }
            return baseUnits;
        }
        throw new InternalError("System Unit cannot be an instance of " + this.getClass());
    }

    private static UnitConverter transformOf(Unit<?> baseUnits) {
        if (baseUnits instanceof BaseUnit) {
            return Dimension.getModel().getTransform((BaseUnit)baseUnits);
        }
        ProductUnit productUnit = (ProductUnit)baseUnits;
        UnitConverter converter = UnitConverter.IDENTITY;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            UnitConverter cvtr = Unit.transformOf(unit);
            if (!cvtr.isLinear()) {
                throw new ConversionException(baseUnits + " is non-linear, cannot convert");
            }
            if (productUnit.getUnitRoot(i) != 1) {
                throw new ConversionException(productUnit + " holds a base unit with fractional exponent");
            }
            int pow = productUnit.getUnitPow(i);
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    public final <A extends Quantity> AlternateUnit<A> alternate(String symbol) {
        return new AlternateUnit(symbol, this);
    }

    public final CompoundUnit<Q> compound(Unit<Q> subunit) {
        return new CompoundUnit<Q>(this, subunit);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        if (this instanceof TransformedUnit) {
            TransformedUnit tf = (TransformedUnit)this;
            Unit parent = tf.getParentUnit();
            UnitConverter toParent = tf.toParentUnit().concatenate(operation);
            if (toParent == UnitConverter.IDENTITY) {
                return parent;
            }
            return new TransformedUnit(parent, toParent);
        }
        if (operation == UnitConverter.IDENTITY) {
            return this;
        }
        return new TransformedUnit(this, operation);
    }

    public final Unit<Q> plus(double offset) {
        return this.transform(new AddConverter(offset));
    }

    public final Unit<Q> times(long factor) {
        return this.transform(new RationalConverter(factor, 1L));
    }

    public final Unit<Q> times(double factor) {
        return this.transform(new MultiplyConverter(factor));
    }

    public final Unit<? extends Quantity> times(Unit<?> that) {
        return ProductUnit.getProductInstance(this, that);
    }

    public final Unit<? extends Quantity> inverse() {
        return ProductUnit.getQuotientInstance(ONE, this);
    }

    public final Unit<Q> divide(long divisor) {
        return this.transform(new RationalConverter(1L, divisor));
    }

    public final Unit<Q> divide(double divisor) {
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final Unit<? extends Quantity> divide(Unit<?> that) {
        return this.times(that.inverse());
    }

    public final Unit<? extends Quantity> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<? extends Quantity> pow(int n) {
        if (n > 0) {
            return this.times(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit<? extends Quantity> valueOf(CharSequence csq) {
        try {
            return UnitFormat.getInstance().parseProductUnit(csq, new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final String toString() {
        return UnitFormat.getInstance().format(this);
    }
}

