/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class StreamLogger
extends Thread {
    private InputStream is;
    private PrintStream ps;
    private Logger logger;
    private Pattern ignorePattern = null;

    public StreamLogger(InputStream is, String logCategory, String ignorePattern) {
        this.is = is;
        this.logger = logCategory == null ? MaryUtils.getLogger("unnamed") : MaryUtils.getLogger(logCategory);
        if (ignorePattern != null) {
            try {
                this.ignorePattern = Pattern.compile(ignorePattern);
            }
            catch (PatternSyntaxException e) {
                this.logger.warn((Object)"Problem with regular expression pattern", (Throwable)e);
                this.ignorePattern = null;
            }
        }
    }

    public StreamLogger(InputStream is, PrintStream ps) {
        this.is = is;
        this.ps = ps;
    }

    @Override
    public void run() {
        String line = null;
        try {
            BufferedReader b = new BufferedReader(new InputStreamReader(this.is));
            while ((line = b.readLine()) != null) {
                if (this.ignorePattern != null && this.ignorePattern.matcher(line).matches()) continue;
                if (this.ps != null) {
                    this.ps.println(line);
                    continue;
                }
                this.logger.info((Object)line);
            }
        }
        catch (IOException e) {
            try {
                this.logger.warn((Object)"Cannot read from stream", (Throwable)e);
            }
            catch (NullPointerException npe) {
                e.printStackTrace();
            }
        }
    }
}

