/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryNormalisedWriter;
import marytts.util.dom.NameNodeFilter;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DomUtils {
    protected static DocumentBuilderFactory factory;
    protected static DocumentBuilderFactory validatingFactory;
    protected static Logger logger;

    public static Document parseDocument(String inputData, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(new StringReader(inputData), validating);
    }

    public static Document parseDocument(Reader inputData, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DomUtils.createDocumentBuilder(validating);
        return builder.parse(new InputSource(inputData));
    }

    public static Document parseDocument(File file, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(new FileInputStream(file), validating);
    }

    public static Document parseDocument(InputStream is, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DomUtils.createDocumentBuilder(validating);
        return builder.parse(is);
    }

    private static DocumentBuilder createDocumentBuilder(boolean validating) throws ParserConfigurationException {
        DocumentBuilder builder;
        if (validating) {
            if (validatingFactory == null) {
                throw new ParserConfigurationException("No validating parser factory available");
            }
            if (!validatingFactory.isValidating()) {
                throw new ParserConfigurationException("factory should be validating but isn't");
            }
            builder = validatingFactory.newDocumentBuilder();
            assert (builder.isValidating());
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                @Override
                public void warning(SAXParseException e) throws SAXParseException {
                    throw e;
                }
            });
        } else {
            builder = factory.newDocumentBuilder();
        }
        return builder;
    }

    public static Document parseDocument(String inputData) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(inputData, false);
    }

    public static Document parseDocument(Reader inputData) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(inputData, false);
    }

    public static Document parseDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(file, false);
    }

    public static Document parseDocument(InputStream inputData) throws ParserConfigurationException, SAXException, IOException {
        return DomUtils.parseDocument(inputData, false);
    }

    public static boolean isAncestor(Node ancestor, Node node) {
        Node p = node;
        while ((p = p.getParentNode()) != null) {
            if (ancestor != p) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAncestor(Node node, String ancestorName) {
        Node p = node;
        while ((p = p.getParentNode()) != null) {
            if (!p.getNodeName().equals(ancestorName)) continue;
            return true;
        }
        return false;
    }

    public static Node getAncestor(Node node, String ancestorName) {
        Node p = node;
        while ((p = p.getParentNode()) != null) {
            if (!p.getNodeName().equals(ancestorName)) continue;
            return p;
        }
        return null;
    }

    public static Node getAncestor(Node node, String[] ancestorNames) {
        if (ancestorNames.length <= 0) {
            throw new IllegalArgumentException("No ancestorNames provided.");
        }
        Node closestAncestor = null;
        for (int i = 0; i < ancestorNames.length; ++i) {
            Node ancestor = DomUtils.getAncestor(node, ancestorNames[i]);
            if (ancestor == null) continue;
            if (closestAncestor == null) {
                closestAncestor = ancestor;
                continue;
            }
            if (!DomUtils.isAncestor(closestAncestor, ancestor)) continue;
            closestAncestor = ancestor;
        }
        return closestAncestor;
    }

    public static Element getClosestAncestorWithAttribute(Node node, String ancestorName, String attributeName) {
        Node a = DomUtils.getAncestor(node, ancestorName);
        while (a != null) {
            if (a.getNodeType() == 1 && ((Element)a).hasAttribute(attributeName)) {
                return (Element)a;
            }
            a = DomUtils.getAncestor(a, ancestorName);
        }
        return null;
    }

    public static String getAttributeFromClosestAncestorOfAnyKind(Node node, String attributeName) {
        Node parentNode;
        while (node != null && (parentNode = node.getParentNode()) != null) {
            Element parentElement;
            if (parentNode.hasAttributes() && (parentElement = (Element)parentNode).hasAttribute(attributeName)) {
                return parentElement.getAttribute(attributeName);
            }
            node = parentNode;
        }
        return "";
    }

    public static Node getHighestLevelAncestor(Node node, String ancestorName) {
        Node p = node;
        Node highest = null;
        while ((p = DomUtils.getAncestor(p, ancestorName)) != null) {
            highest = p;
        }
        return highest;
    }

    public static Element getNextSiblingElement(Element e) {
        Node n = e;
        if (n == null) {
            return null;
        }
        while ((n = n.getNextSibling()) != null) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Element e) {
        Node n = e;
        if (n == null) {
            return null;
        }
        while ((n = n.getPreviousSibling()) != null) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getNextSiblingElementByTagName(Element e, String name) {
        Node n = e;
        if (n == null) {
            return null;
        }
        while ((n = n.getNextSibling()) != null) {
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getPreviousSiblingElementByTagName(Element e, String name) {
        Node n = e;
        if (n == null) {
            return null;
        }
        while ((n = n.getPreviousSibling()) != null) {
            if (n.getNodeType() != 1 || !((Element)n).getTagName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getFirstChildElement(Element e) {
        Node n;
        for (n = e.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }

    public static Element getLastChildElement(Element e) {
        Node n;
        for (n = e.getLastChild(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
        }
        return (Element)n;
    }

    public static Element getFirstElementByTagName(Node n, String name) {
        Document doc = n instanceof Document ? (Document)n : n.getOwnerDocument();
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(n, 1, new NameNodeFilter(name), true);
        return (Element)tw.nextNode();
    }

    public static Element getLastElementByTagName(Element e, String name) {
        TreeWalker tw = ((DocumentTraversal)((Object)e.getOwnerDocument())).createTreeWalker(e, 1, new NameNodeFilter(name), true);
        Node current = null;
        Node previous = null;
        while ((current = tw.nextNode()) != null) {
            previous = current;
        }
        return (Element)previous;
    }

    public static boolean isFirstOfItsKindIn(Node node, String ancestorName) {
        return DomUtils.isFirstOfItsKindIn(node, DomUtils.getAncestor(node, ancestorName));
    }

    public static boolean isFirstOfItsKindIn(Node node, Node ancestor) {
        if (ancestor == null) {
            return false;
        }
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            return false;
        }
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, -1, new NameNodeFilter(node.getNodeName()), true);
        tw.setCurrentNode(node);
        Node prev = tw.previousNode();
        return prev == null || !DomUtils.isAncestor(ancestor, prev);
    }

    public static boolean isLastOfItsKindIn(Node node, String ancestorName) {
        return DomUtils.isLastOfItsKindIn(node, DomUtils.getAncestor(node, ancestorName));
    }

    public static boolean isLastOfItsKindIn(Node node, Node ancestor) {
        if (node == null || ancestor == null) {
            return false;
        }
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            return false;
        }
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, -1, new NameNodeFilter(node.getNodeName()), true);
        tw.setCurrentNode(node);
        Node next = tw.nextNode();
        return next == null || !DomUtils.isAncestor(ancestor, next);
    }

    public static Element getPreviousOfItsKindIn(Element element, Element root) {
        if (element == null || root == null) {
            return null;
        }
        String tagname = element.getTagName();
        TreeWalker tw = ((DocumentTraversal)((Object)element.getOwnerDocument())).createTreeWalker(root, 1, new NameNodeFilter(tagname), true);
        tw.setCurrentNode(element);
        Node previous = tw.previousNode();
        while (previous != null) {
            if (previous.getNodeName().equals(tagname)) {
                return (Element)previous;
            }
            previous = tw.previousNode();
        }
        return null;
    }

    public static Element getNextOfItsKindIn(Element element, Element root) {
        if (element == null || root == null) {
            return null;
        }
        String tagname = element.getTagName();
        TreeWalker tw = ((DocumentTraversal)((Object)element.getOwnerDocument())).createTreeWalker(root, 1, new NameNodeFilter(tagname), true);
        tw.setCurrentNode(element);
        Node next = tw.nextNode();
        while (next != null) {
            if (next.getNodeName().equals(tagname)) {
                return (Element)next;
            }
            next = tw.nextNode();
        }
        return null;
    }

    public static Element closestCommonAncestor(Node first, Node last) {
        Element a;
        if (first == null || last == null) {
            return null;
        }
        for (a = (Element)first.getParentNode(); a != null && !DomUtils.isAncestor(a, last); a = (Element)a.getParentNode()) {
        }
        return a;
    }

    public static Element encloseNodesWithNewElement(Node first, Node last, String newElementName) {
        if (first == null || last == null) {
            return null;
        }
        Element a = DomUtils.closestCommonAncestor(first, last);
        if (a == null) {
            return null;
        }
        Node childA = first;
        while (childA.getParentNode() != a) {
            childA = childA.getParentNode();
        }
        Node childZ = last;
        while (childZ.getParentNode() != a) {
            childZ = childZ.getParentNode();
        }
        Document doc = a.getNodeType() == 9 ? (Document)((Object)a) : a.getOwnerDocument();
        Element newElement = doc.createElementNS(doc.getDocumentElement().getNamespaceURI(), newElementName);
        a.insertBefore(newElement, childA);
        Node c = childA;
        while (c != null && c != childZ) {
            Node helper = c.getNextSibling();
            newElement.appendChild(c);
            c = helper;
        }
        newElement.appendChild(childZ);
        return newElement;
    }

    public static List<Node> getNodeListAsList(NodeList nl) {
        ArrayList<Node> l = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            l.add(nl.item(i));
        }
        return l;
    }

    public static String getPlainTextBelow(Node n) {
        if (n == null) {
            return null;
        }
        Document doc = null;
        doc = n.getNodeType() == 9 ? (Document)n : n.getOwnerDocument();
        StringBuilder buf = new StringBuilder();
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(n, 4, null, true);
        Text text = null;
        while ((text = (Text)it.nextNode()) != null) {
            buf.append(text.getData().trim());
            buf.append(" ");
        }
        return buf.toString();
    }

    public static void insertAfter(Node newNode, Node refNode) throws DOMException {
        Node parent = refNode.getParentNode();
        Node next = refNode.getNextSibling();
        if (next == null) {
            parent.appendChild(newNode);
        } else {
            parent.insertBefore(newNode, next);
        }
    }

    public static void trimAllTextNodes(Node root) {
        Document doc = root.getNodeType() == 9 ? (Document)root : root.getOwnerDocument();
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(root, 4, null, false);
        Text t = null;
        while ((t = (Text)it.nextNode()) != null) {
            String s = t.getData();
            t.setData(s.trim());
        }
    }

    public static String serializeToString(Document doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MaryNormalisedWriter mnw = new MaryNormalisedWriter();
            mnw.output(doc, baos);
        }
        catch (Exception e1) {
            return "";
        }
        return baos.toString();
    }

    public static String document2String(Document document) throws MaryConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DomUtils.document2Stream(document, baos);
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new MaryConfigurationException("oops", uee);
        }
    }

    public static void document2File(Document document, File file) throws MaryConfigurationException, IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            DomUtils.document2Stream(document, fos);
        }
    }

    public static void document2Stream(Document document, OutputStream target) throws MaryConfigurationException {
        LSSerializer serializer = null;
        DOMImplementationLS domImplLS = null;
        try {
            DOMImplementation implementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
            if (implementation != null) {
                domImplLS = (DOMImplementationLS)implementation.getFeature("LS", "3.0");
            }
        }
        catch (Exception iae) {
            throw new MaryConfigurationException("Cannot access dom impl registry", iae);
        }
        if (domImplLS != null) {
            serializer = domImplLS.createLSSerializer();
            DOMConfiguration config = serializer.getDomConfig();
            if (config.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                config.setParameter("format-pretty-print", Boolean.TRUE);
            }
            if (config.canSetParameter("canonical-form", Boolean.TRUE)) {
                config.setParameter("canonical-form", Boolean.TRUE);
            }
        }
        if (domImplLS != null) {
            LSOutput output = domImplLS.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(target);
            serializer.write(document, output);
        } else {
            MaryNormalisedWriter mnw = new MaryNormalisedWriter();
            try {
                mnw.output(document, target);
            }
            catch (TransformerException te) {
                throw new MaryConfigurationException("Problem writing document with legacy writer", te);
            }
        }
    }

    public static void replaceElement(Element oldElement, NodeList newNodes) {
        Document doc = oldElement.getOwnerDocument();
        Node parent = oldElement.getParentNode();
        int len = newNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = newNodes.item(i);
            if (!doc.equals(n.getOwnerDocument())) {
                n = doc.importNode(n, true);
            }
            parent.insertBefore(n, oldElement);
        }
        parent.removeChild(oldElement);
    }

    public static TreeWalker createTreeWalker(Document doc, Node root, String ... tagNames) {
        return ((DocumentTraversal)((Object)doc)).createTreeWalker(root, 1, new NameNodeFilter(tagNames), false);
    }

    public static TreeWalker createTreeWalker(Node root, String ... tagNames) {
        return DomUtils.createTreeWalker(root.getNodeType() == 9 ? (Document)root : root.getOwnerDocument(), root, tagNames);
    }

    public static NodeIterator createNodeIterator(Document doc, Node root, String ... tagNames) {
        return ((DocumentTraversal)((Object)doc)).createNodeIterator(root, 1, new NameNodeFilter(tagNames), false);
    }

    public static NodeIterator createNodeIterator(Node root, String ... tagNames) {
        return DomUtils.createNodeIterator(root.getNodeType() == 9 ? (Document)root : root.getOwnerDocument(), root, tagNames);
    }

    public static void trimEmptyTextNodes(Node node) {
        Element element = null;
        if (node instanceof Document) {
            element = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            element = (Element)node;
        } else {
            return;
        }
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Text t;
            Node child = children.item(i);
            if (child instanceof Element) {
                DomUtils.trimEmptyTextNodes(child);
                continue;
            }
            if (!(child instanceof Text) || (t = (Text)child).getData().trim().length() != 0) continue;
            nodesToRemove.add(child);
        }
        for (Node n : nodesToRemove) {
            element.removeChild(n);
        }
    }

    public static void compareNodes(Node expected, Node actual, boolean trimEmptyTextNodes) throws Exception {
        String actualData;
        String expectedData;
        if (trimEmptyTextNodes) {
            DomUtils.trimEmptyTextNodes(expected);
            DomUtils.trimEmptyTextNodes(actual);
        }
        if (expected.getNodeType() != actual.getNodeType()) {
            throw new Exception("Different types of nodes: " + expected + " " + actual);
        }
        if (expected instanceof Document) {
            Document expectedDoc = (Document)expected;
            Document actualDoc = (Document)actual;
            DomUtils.compareNodes(expectedDoc.getDocumentElement(), actualDoc.getDocumentElement(), false);
        } else if (expected instanceof Element) {
            Element expectedElement = (Element)expected;
            Element actualElement = (Element)actual;
            if (!expectedElement.getLocalName().equals(actualElement.getLocalName())) {
                throw new Exception("Element names do not match: " + expectedElement.getLocalName() + " " + actualElement.getLocalName());
            }
            String expectedNS = expectedElement.getNamespaceURI();
            String actualNS = actualElement.getNamespaceURI();
            if (expectedNS == null && actualNS != null || expectedNS != null && !expectedNS.equals(actualNS)) {
                throw new Exception("Element namespaces names do not match: " + expectedNS + " " + actualNS);
            }
            String elementName = "{" + expectedElement.getNamespaceURI() + "}" + actualElement.getLocalName();
            NamedNodeMap expectedAttrs = expectedElement.getAttributes();
            NamedNodeMap actualAttrs = actualElement.getAttributes();
            if (DomUtils.countNonNamespaceAttributes(expectedAttrs) != DomUtils.countNonNamespaceAttributes(actualAttrs)) {
                throw new Exception(elementName + ": Number of attributes do not match up: " + DomUtils.countNonNamespaceAttributes(expectedAttrs) + " " + DomUtils.countNonNamespaceAttributes(actualAttrs));
            }
            for (int i = 0; i < expectedAttrs.getLength(); ++i) {
                Attr expectedAttr = (Attr)expectedAttrs.item(i);
                if (expectedAttr.getName().startsWith("xmlns")) continue;
                Attr actualAttr = null;
                actualAttr = (Attr)actualAttrs.getNamedItem(expectedAttr.getName());
                if (actualAttr == null) {
                    throw new Exception(elementName + ": No attribute found:" + expectedAttr);
                }
                if (expectedAttr.getValue().equals(actualAttr.getValue())) continue;
                throw new Exception(elementName + ": Attribute values do not match: " + expectedAttr.getValue() + " " + actualAttr.getValue());
            }
            NodeList expectedChildren = expectedElement.getChildNodes();
            NodeList actualChildren = actualElement.getChildNodes();
            if (expectedChildren.getLength() != actualChildren.getLength()) {
                throw new Exception(elementName + ": Number of children do not match up: " + expectedChildren.getLength() + " " + actualChildren.getLength());
            }
            for (int i = 0; i < expectedChildren.getLength(); ++i) {
                Node expectedChild = expectedChildren.item(i);
                Node actualChild = actualChildren.item(i);
                DomUtils.compareNodes(expectedChild, actualChild, false);
            }
        } else if (expected instanceof Text && !(expectedData = ((Text)expected).getData().trim()).equals(actualData = ((Text)actual).getData().trim())) {
            throw new Exception("Text does not match: " + expectedData + " " + actualData);
        }
    }

    private static int countNonNamespaceAttributes(NamedNodeMap attrs) {
        int n = 0;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            ++n;
        }
        return n;
    }

    static {
        logger = MaryUtils.getLogger("DomUtils");
        factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setNamespaceAware(true);
        validatingFactory = DocumentBuilderFactory.newInstance();
        validatingFactory.setExpandEntityReferences(true);
        validatingFactory.setNamespaceAware(true);
        validatingFactory.setIgnoringElementContentWhitespace(true);
        validatingFactory.setValidating(true);
        try {
            validatingFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            Object[] schemas = new Object[]{DomUtils.class.getResource("xml.xsd").toString(), DomUtils.class.getResource("MaryXML.xsd").toString()};
            validatingFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemas);
        }
        catch (Exception x) {
            logger.warn((Object)"Cannot use Schema validation -- disabling validating parser factory.");
            validatingFactory = null;
        }
    }
}

