/*
 * Decompiled with CFR 0.152.
 */
package marytts.fst;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import marytts.fst.AlignerTrainer;
import marytts.fst.FSTLookup;
import marytts.fst.StringPair;
import marytts.fst.Trie;

public class TransducerTrie
extends Trie<StringPair> {
    static int ARCOFFSET_BITS = 20;
    static int OVERALL_BITS = 32;
    static int LABELID_BITS = OVERALL_BITS - (ARCOFFSET_BITS + 1);

    public void writeFST(DataOutputStream out, String encoding) throws IOException {
        StringPair ioSym;
        int i;
        if (null == this.reprs) {
            throw new IllegalStateException("Cannot write transducer: first compute minimization of trie.");
        }
        int[] arcOffsets = new int[this.reprs.size() + 1];
        arcOffsets[0] = 1;
        for (int i2 = 0; i2 < this.rlist.size(); ++i2) {
            arcOffsets[i2 + 1] = arcOffsets[i2] + ((Trie.TrieNode)this.rlist.get(i2)).getArcMap().size();
            if (!((Trie.TrieNode)this.rlist.get((int)i2)).isFinal) continue;
            int n = i2 + 1;
            arcOffsets[n] = arcOffsets[n] + 1;
        }
        int maxAO = arcOffsets[arcOffsets.length - 1];
        if (maxAO >> ARCOFFSET_BITS != 0) {
            int numBitsNeeded = (int)Math.ceil(Math.log(maxAO) / Math.log(2.0));
            throw new IOException("Cannot write transducer: too many arcs to be encoded in binary fst format (would need " + numBitsNeeded + " bits, have " + ARCOFFSET_BITS + ")");
        }
        int maxLID = this.labels.size() + 2;
        if (maxLID >> LABELID_BITS != 0) {
            int numBitsNeeded = (int)Math.ceil(Math.log(maxLID) / Math.log(2.0));
            throw new IOException("Cannot write transducer: too many arc-labels to be encoded in binary fst format (would need " + numBitsNeeded + " bits, have " + LABELID_BITS + ")");
        }
        if (!Charset.isSupported(encoding)) {
            throw new IOException("Cannot write transducer: encoding not supported.");
        }
        out.writeInt(encoding.length());
        out.write(encoding.getBytes("UTF-8"));
        out.writeInt(OVERALL_BITS);
        out.writeInt(ARCOFFSET_BITS);
        out.writeInt(maxAO);
        int startArc = arcOffsets[this.root.getId()] | 0x100000 | Integer.MIN_VALUE;
        out.writeInt(startArc);
        for (Trie.TrieNode repr : this.rlist) {
            ArrayList<Integer> arcVals = new ArrayList<Integer>();
            for (Integer labelId : repr.getArcMap().keySet()) {
                int targetId = repr.getArcMap().get(labelId).getId();
                arcVals.add(arcOffsets[targetId] | labelId + 2 << 20);
            }
            if (repr.isFinal) {
                arcVals.add(arcOffsets[repr.getId()] | 0 | Integer.MIN_VALUE);
            } else {
                int last = arcVals.size() - 1;
                arcVals.set(last, (Integer)arcVals.get(last) | Integer.MIN_VALUE);
            }
            for (Integer val : arcVals) {
                out.writeInt(val);
            }
        }
        int[] labelOffsets = new int[this.labels.size() * 2];
        labelOffsets[0] = 4;
        for (i = 0; i < this.labels.size(); ++i) {
            ioSym = (StringPair)this.labels.get(i);
            labelOffsets[i * 2 + 1] = labelOffsets[i * 2];
            int n = i * 2 + 1;
            labelOffsets[n] = labelOffsets[n] + ioSym.getString1().getBytes(encoding).length;
            int n2 = i * 2 + 1;
            labelOffsets[n2] = labelOffsets[n2] + 1;
            if (i + 1 >= this.labels.size()) continue;
            labelOffsets[(i + 1) * 2] = labelOffsets[i * 2 + 1];
            int n3 = (i + 1) * 2;
            labelOffsets[n3] = labelOffsets[n3] + ioSym.getString2().getBytes(encoding).length;
            int n4 = (i + 1) * 2;
            labelOffsets[n4] = labelOffsets[n4] + 1;
        }
        out.writeInt(this.labels.size() + 2);
        out.writeShort(0);
        out.writeShort(1);
        out.writeShort(2);
        out.writeShort(3);
        for (i = 0; i < this.labels.size(); ++i) {
            out.writeShort(labelOffsets[i * 2]);
            out.writeShort(labelOffsets[i * 2 + 1]);
        }
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(0);
        out.writeByte(0);
        for (i = 0; i < this.labels.size(); ++i) {
            ioSym = (StringPair)this.labels.get(i);
            out.write(ioSym.getString1().getBytes(encoding));
            out.writeByte(0);
            out.write(ioSym.getString2().getBytes(encoding));
            out.writeByte(0);
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "/Users/benjaminroth/Desktop/mary/fst/german/";
        BufferedReader lexReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path + "lexicon.txt"), "ISO-8859-1"));
        String fstLocation = path + "lexicon.fst";
        AlignerTrainer at = new AlignerTrainer(false, true);
        System.out.println("reading lexicon...");
        at.readLexicon(lexReader, "\\\\");
        System.out.println("...done!");
        System.out.println("aligning...");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 4; ++i) {
            System.out.println(" iteration " + (i + 1));
            at.alignIteration();
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("...done!");
        System.out.println("alignment took " + time + "ms");
        TransducerTrie t = new TransducerTrie();
        System.out.println("entering alignments in trie...");
        for (int i = 0; i < at.lexiconSize(); ++i) {
            t.add(at.getAlignment(i));
            t.add(at.getInfoAlignment(i));
        }
        System.out.println("...done!");
        System.out.println("minimizing trie...");
        t.computeMinimization();
        System.out.println("...done!");
        System.out.println("writing transducer to disk...");
        File of = new File(fstLocation);
        DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(of)));
        t.writeFST(os, "UTF-8");
        os.flush();
        os.close();
        System.out.println("...done!");
        System.out.println("looking up test words...");
        FSTLookup fst = new FSTLookup(fstLocation);
        System.out.println(" Fahrrad -> " + Arrays.toString(fst.lookup("Fahrrad")));
        System.out.println(" fahren -> " + Arrays.toString(fst.lookup("fahren")));
        System.out.println(" Umwelt -> " + Arrays.toString(fst.lookup("Umwelt")));
        System.out.println(" schonen -> " + Arrays.toString(fst.lookup("schonen")));
        System.out.println(" abgerechnet -> " + Arrays.toString(fst.lookup("abgerechnet")));
        System.out.println(" abgerechnet(A) -> " + Arrays.toString(fst.lookup("abgerechnet(A)")));
        System.out.println(" absorbieren -> " + Arrays.toString(fst.lookup("absorbieren")));
        System.out.println(" absorbieren(WV1b) -> " + Arrays.toString(fst.lookup("absorbieren(WV1b)")));
        System.out.println(" \u00fcbersetzen -> " + Arrays.toString(fst.lookup("\u00fcbersetzen")));
        System.out.println("...done!");
    }
}

