/*
 * Decompiled with CFR 0.152.
 */
package marytts.fst;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marytts.fst.FST;

public class FSTLookup {
    private static Map<String, FST> knownFSTs = new HashMap<String, FST>();
    private FST fst;

    public FSTLookup(String fileName) throws IOException {
        try (FileInputStream inStream = new FileInputStream(fileName);){
            this.init(inStream, fileName);
        }
    }

    public FSTLookup(InputStream inStream, String identifier) throws IOException {
        this.init(inStream, identifier);
    }

    private void init(InputStream inStream, String identifier) throws IOException {
        this.fst = knownFSTs.get(identifier);
        if (this.fst == null) {
            this.fst = new FST(inStream);
            knownFSTs.put(identifier, this.fst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTLookup(String fileName, String encoding) throws IOException, UnsupportedEncodingException {
        try (FileInputStream inStream = new FileInputStream(fileName);){
            this.init(inStream, fileName, encoding);
        }
    }

    public FSTLookup(InputStream inStream, String identifier, String encoding) throws IOException, UnsupportedEncodingException {
        this.init(inStream, identifier, encoding);
    }

    private void init(InputStream inStream, String identifier, String encoding) throws IOException, UnsupportedEncodingException {
        String key = identifier + " " + encoding;
        this.fst = knownFSTs.get(key);
        if (this.fst == null) {
            this.fst = new FST(inStream, encoding);
            knownFSTs.put(key, this.fst);
        }
    }

    public String[] lookup(String word) {
        return this.lookup(word, false);
    }

    public String[] lookup(String word, boolean generate) {
        StringBuilder buffer2 = new StringBuilder();
        ArrayList<String> results = new ArrayList<String>();
        this.lookup(word, 0, 0, generate, buffer2, results);
        String[] resultArray = new String[results.size()];
        resultArray = results.toArray(resultArray);
        return resultArray;
    }

    private void lookup(String word, int offset1, int arc, boolean generate, StringBuilder buffer2, List<String> results) {
        do {
            short label = this.fst.labels[arc];
            int offset2 = buffer2.length();
            if (label == 0) {
                if (offset1 != word.length()) continue;
                results.add(buffer2.toString());
                continue;
            }
            String s1 = generate ? (String)this.fst.strings.get(this.fst.mapping[this.fst.offsets[2 * label + 1]]) : (String)this.fst.strings.get(this.fst.mapping[this.fst.offsets[2 * label]]);
            if (!word.startsWith(s1, offset1)) continue;
            String s2 = generate ? (String)this.fst.strings.get(this.fst.mapping[this.fst.offsets[2 * label]]) : (String)this.fst.strings.get(this.fst.mapping[this.fst.offsets[2 * label + 1]]);
            buffer2.append(s2);
            this.lookup(word, offset1 + s1.length(), this.fst.targets[arc], generate, buffer2, results);
            if (offset2 >= buffer2.length()) continue;
            buffer2.delete(offset2, buffer2.length());
        } while (!this.fst.isLast[arc++]);
    }

    public static void main(String[] args) throws IOException {
        long iBegin = System.currentTimeMillis();
        if (args.length == 0) {
            System.err.println("usage: java marytts.fst.FSTLookup FstFile [-g] [word ...]");
            System.exit(-1);
        }
        FSTLookup fstLookup = new FSTLookup(args[0]);
        if (args.length == 1 || args.length == 2 && args[1].equals("-g")) {
            boolean generate = false;
            if (args.length == 2 && args[1].equals("-g")) {
                generate = true;
            }
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                while ((line = in.readLine()) != null) {
                    FSTLookup.showResults(line, fstLookup.lookup(line, generate));
                }
            }
            catch (Exception e) {
                System.err.println("Invalid Input");
            }
        } else {
            int i = 1;
            boolean generate = false;
            if (args[1].equals("-g")) {
                generate = true;
                i = 2;
            }
            while (i < args.length) {
                FSTLookup.showResults(args[i], fstLookup.lookup(args[i], generate));
                ++i;
            }
        }
        long iEnd = System.currentTimeMillis();
        System.err.println("processed in " + (iEnd - iBegin) + " ms.");
    }

    public static void showResults(String query, String[] args) {
        System.out.println("---- " + args.length + " result(s) for " + query + ":");
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        System.out.println();
    }
}

