/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.ConfigHandler;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxLoader {
    private final URL url;
    private final Map<String, RawPropertyData> rpdMap;
    private final Map<String, String> globalProperties;
    private final boolean replaceDuplicates;

    public SaxLoader(URL url, Map<String, String> globalProperties, Map<String, RawPropertyData> initRPD, boolean replaceDuplicates) {
        this.url = url;
        this.globalProperties = globalProperties;
        this.replaceDuplicates = replaceDuplicates;
        this.rpdMap = initRPD == null ? new HashMap() : initRPD;
    }

    public SaxLoader(URL url, Map<String, String> globalProperties) {
        this(url, globalProperties, null, false);
    }

    public Map<String, RawPropertyData> load() throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xr = factory.newSAXParser().getXMLReader();
            ConfigHandler handler = new ConfigHandler(this.rpdMap, this.globalProperties, this.replaceDuplicates, this.url);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            InputStream is = this.url.openStream();
            xr.parse(new InputSource(is));
            is.close();
        }
        catch (SAXParseException e) {
            String msg = "Error while parsing line " + e.getLineNumber() + " of " + this.url + ": " + e.getMessage();
            throw new IOException(msg);
        }
        catch (SAXException e) {
            throw new IOException("Problem with XML: " + e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        return this.rpdMap;
    }
}

