/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class Utilities {
    private static final boolean TRACKING_OBJECTS = false;
    static long maxUsed;

    private Utilities() {
    }

    public static String pad(int padding) {
        if (padding > 0) {
            StringBuilder sb = new StringBuilder(padding);
            for (int i = 0; i < padding; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        return "";
    }

    public static String pad(String string, int minLength) {
        String result = string;
        int pad = minLength - string.length();
        if (pad > 0) {
            result = string + Utilities.pad(minLength - string.length());
        } else if (pad < 0) {
            result = string.substring(0, minLength);
        }
        return result;
    }

    public static String pad(int val, int minLength) {
        return Utilities.pad(String.valueOf(val), minLength);
    }

    public static String pad(double val, int minLength) {
        return Utilities.pad(String.valueOf(val), minLength);
    }

    public static String getReadable(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c) && !Character.isUpperCase(name.charAt(i - 1))) {
                builder.append(' ');
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static void dump(PrintWriter pw, int padding, String string) {
        pw.print(Utilities.pad(padding));
        pw.println(string);
    }

    public static void objectTracker(String name, int count) {
    }

    public static void dumpMemoryInfo(String msg) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        rt.gc();
        long reclaimedMemory = (rt.freeMemory() - free) / 0x100000L;
        long freeMemory = rt.freeMemory() / 0x100000L;
        long totalMemory = rt.totalMemory() / 0x100000L;
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        if (usedMemory > maxUsed) {
            maxUsed = usedMemory;
        }
        System.out.println("Memory (mb)  total: " + totalMemory + " reclaimed: " + reclaimedMemory + " free: " + freeMemory + " Max Used: " + maxUsed / 0x100000L + " -- " + msg);
    }

    public static String doubleToScientificString(double number, int fractionDigits) {
        DecimalFormat format = new DecimalFormat();
        StringBuilder formatter = new StringBuilder(5 + fractionDigits).append("0.");
        for (int i = 0; i < fractionDigits; ++i) {
            formatter.append('0');
        }
        formatter.append("E00");
        format.applyPattern(formatter.toString());
        String formatted = format.format(number);
        int index = formatted.indexOf(69);
        if (formatted.charAt(index + 1) != '-') {
            return formatted.substring(0, index + 1) + '+' + formatted.substring(index + 1);
        }
        return formatted;
    }

    public static boolean isCepstraFileBigEndian(String filename) throws IOException {
        File cepstraFile = new File(filename);
        int fileSize = (int)cepstraFile.length();
        DataInputStream stream = new DataInputStream(new FileInputStream(filename));
        int numberBytes = stream.readInt() * 4 + 4;
        stream.close();
        return fileSize == numberBytes;
    }

    public static float readLittleEndianFloat(DataInputStream dataStream) throws IOException {
        return Float.intBitsToFloat(Utilities.readLittleEndianInt(dataStream));
    }

    public static int readLittleEndianInt(DataInputStream dataStream) throws IOException {
        return dataStream.readUnsignedByte() | dataStream.readUnsignedByte() << 8 | dataStream.readUnsignedByte() << 16 | dataStream.readUnsignedByte() << 24;
    }

    public static int swapInteger(int integer) {
        return (0xFF & integer) << 24 | (0xFF00 & integer) << 8 | (0xFF0000 & integer) >> 8 | (0xFF000000 & integer) >> 24;
    }

    public static float swapFloat(float floatValue) {
        return Float.intBitsToFloat(Utilities.swapInteger(Float.floatToRawIntBits(floatValue)));
    }

    public static void floorData(float[] data, float floor) {
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < floor)) continue;
            data[i] = floor;
        }
    }

    public static void nonZeroFloor(float[] data, float floor) {
        for (int i = 0; i < data.length; ++i) {
            if ((double)data[i] == 0.0 || !(data[i] < floor)) continue;
            data[i] = floor;
        }
    }

    public static void normalize(float[] data) {
        float sum = 0.0f;
        for (float val : data) {
            sum += val;
        }
        if (sum != 0.0f) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = data[i] / sum;
            }
        }
    }
}

