/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.util.HashMap;
import java.util.Map;

public class StatisticsVariable {
    private static final Map<String, StatisticsVariable> pool = new HashMap<String, StatisticsVariable>();
    public double value;
    private final String name;
    private boolean enabled;

    public static StatisticsVariable getStatisticsVariable(String statName) {
        StatisticsVariable stat = pool.get(statName);
        if (stat == null) {
            stat = new StatisticsVariable(statName);
            pool.put(statName, stat);
        }
        return stat;
    }

    public static StatisticsVariable getStatisticsVariable(String instanceName, String statName) {
        return StatisticsVariable.getStatisticsVariable(instanceName + '.' + statName);
    }

    public static void dumpAll() {
        System.out.println(" ========= statistics  =======");
        for (StatisticsVariable stats : pool.values()) {
            stats.dump();
        }
    }

    public static void resetAll() {
        for (StatisticsVariable stats : pool.values()) {
            stats.reset();
        }
    }

    private StatisticsVariable(String statName) {
        this.name = statName;
        this.value = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void reset() {
        this.setValue(0.0);
    }

    public void dump() {
        if (this.isEnabled()) {
            System.out.println(this.name + ' ' + this.value);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static void main(String[] args) {
        StatisticsVariable loops = StatisticsVariable.getStatisticsVariable("main", "loops");
        StatisticsVariable sum = StatisticsVariable.getStatisticsVariable("main", "sum");
        StatisticsVariable foot = StatisticsVariable.getStatisticsVariable("body", "foot");
        StatisticsVariable leg = StatisticsVariable.getStatisticsVariable("body", "leg");
        StatisticsVariable finger = StatisticsVariable.getStatisticsVariable("body", "finger");
        foot.setValue(2.0);
        leg.setValue(2.0);
        finger.setValue(10.0);
        StatisticsVariable.dumpAll();
        StatisticsVariable.dumpAll();
        for (int i = 0; i < 1000; ++i) {
            loops.value += 1.0;
            sum.value += (double)i;
        }
        StatisticsVariable.dumpAll();
        StatisticsVariable loopsAlias = StatisticsVariable.getStatisticsVariable("main", "loops");
        StatisticsVariable sumAlias = StatisticsVariable.getStatisticsVariable("main", "sum");
        for (int i = 0; i < 1000; ++i) {
            loopsAlias.value += 1.0;
            sumAlias.value += (double)i;
        }
        StatisticsVariable.dumpAll();
        StatisticsVariable.resetAll();
        StatisticsVariable.dumpAll();
    }
}

