/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Path;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.LogMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WordResultPath
implements Path {
    private final List<WordResult> path = new ArrayList<WordResult>();

    WordResultPath(List<WordResult> wordResults) {
        this.path.addAll(wordResults);
    }

    WordResultPath() {
    }

    @Override
    public double getScore() {
        double score = LogMath.getLogOne();
        for (WordResult wr : this.path) {
            score += wr.getScore();
        }
        return score;
    }

    @Override
    public double getConfidence() {
        double confidence = LogMath.getLogOne();
        for (WordResult wr : this.path) {
            confidence += wr.getConfidence();
        }
        return confidence;
    }

    @Override
    public LogMath getLogMath() {
        Iterator<WordResult> i = this.path.iterator();
        if (i.hasNext()) {
            WordResult wr = i.next();
            return wr.getLogMath();
        }
        return null;
    }

    @Override
    public WordResult[] getWords() {
        return this.path.toArray(new WordResult[this.path.size()]);
    }

    @Override
    public String getTranscription() {
        StringBuilder sb = new StringBuilder();
        for (WordResult wr : this.path) {
            sb.append(wr).append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public String getTranscriptionNoFiller() {
        StringBuilder sb = new StringBuilder();
        for (WordResult wordResult : this.path) {
            Word word = wordResult.getPronunciation().getWord();
            if (word.isFiller() || word.getSpelling().equals("<unk>")) continue;
            sb.append(word.getSpelling()).append(' ');
        }
        return sb.toString().trim();
    }

    public void add(WordResult wr) {
        this.path.add(wr);
    }
}

