/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.LogMath;

public class SimpleWordResult
implements WordResult {
    final Word word;
    int startFrame;
    int endFrame;
    final double score;
    final double confidence;
    final LogMath logMath;

    public SimpleWordResult(String w, double confidence, LogMath logMath) {
        Pronunciation[] pros = new Pronunciation[]{Pronunciation.UNKNOWN};
        this.word = new Word(w, pros, false);
        this.confidence = confidence;
        this.score = LogMath.getLogZero();
        this.logMath = logMath;
    }

    public SimpleWordResult(Word w, int sf, int ef, double score, double confidence, LogMath logMath) {
        this.word = w;
        this.startFrame = sf;
        this.endFrame = ef;
        this.score = score;
        this.confidence = confidence;
        this.logMath = logMath;
    }

    public SimpleWordResult(Node node, double confidence, LogMath logMath) {
        this(node.getWord(), node.getBeginTime(), node.getEndTime(), LogMath.getLogZero(), confidence, logMath);
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public double getConfidence() {
        if (this.confidence > (double)LogMath.getLogOne()) {
            return LogMath.getLogOne();
        }
        return this.confidence;
    }

    @Override
    public LogMath getLogMath() {
        return this.logMath;
    }

    @Override
    public Pronunciation getPronunciation() {
        return this.word.getMostLikelyPronunciation();
    }

    @Override
    public int getStartFrame() {
        return this.startFrame;
    }

    @Override
    public int getEndFrame() {
        return this.endFrame;
    }

    @Override
    public String toString() {
        return this.word.toString();
    }

    @Override
    public Data[] getDataFrames() {
        return null;
    }

    @Override
    public boolean isFiller() {
        return this.word.isFiller() || this.word.toString().equals("<skip>");
    }
}

