/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.FrameStatistics;
import edu.cmu.sphinx.util.LogMath;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Result {
    private final ActiveList activeList;
    private final List<Token> resultList;
    private AlternateHypothesisManager alternateHypothesisManager;
    private boolean isFinal;
    private final int currentFrameNumber;
    private String reference;
    private final LogMath logMath;

    public Result(AlternateHypothesisManager alternateHypothesisManager, ActiveList activeList, List<Token> resultList, int frameNumber, boolean isFinal, LogMath logMath) {
        this(activeList, resultList, frameNumber, isFinal, logMath);
        this.alternateHypothesisManager = alternateHypothesisManager;
    }

    public Result(ActiveList activeList, List<Token> resultList, int frameNumber, boolean isFinal, LogMath logMath) {
        this.activeList = activeList;
        this.resultList = resultList;
        this.currentFrameNumber = frameNumber;
        this.isFinal = isFinal;
        this.logMath = logMath;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public LogMath getLogMath() {
        return this.logMath;
    }

    public ActiveList getActiveTokens() {
        return this.activeList;
    }

    public List<Token> getResultTokens() {
        return this.resultList;
    }

    public AlternateHypothesisManager getAlternateHypothesisManager() {
        return this.alternateHypothesisManager;
    }

    public int getFrameNumber() {
        return this.currentFrameNumber;
    }

    public Token getBestFinalToken() {
        Token bestToken = null;
        for (Token token : this.resultList) {
            if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
            bestToken = token;
        }
        return bestToken;
    }

    public Token getBestToken() {
        Token bestToken = this.getBestFinalToken();
        if (bestToken == null) {
            bestToken = this.getBestActiveToken();
        }
        return bestToken;
    }

    public Token getBestActiveToken() {
        Token bestToken = null;
        if (this.activeList != null) {
            for (Token token : this.activeList) {
                if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
                bestToken = token;
            }
        }
        return bestToken;
    }

    public Token findToken(String text) {
        text = text.trim();
        for (Token token : this.resultList) {
            if (!text.equals(token.getWordPathNoFiller())) continue;
            return token;
        }
        return null;
    }

    public List<Token> findPartialMatchingTokens(String text) {
        ArrayList<Token> list = new ArrayList<Token>();
        text = text.trim();
        for (Token token : this.activeList) {
            if (!text.startsWith(token.getWordPathNoFiller())) continue;
            list.add(token);
        }
        return list;
    }

    public Token getBestActiveParitalMatchingToken(String text) {
        List<Token> matchingList = this.findPartialMatchingTokens(text);
        Token bestToken = null;
        for (Token token : matchingList) {
            if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
            bestToken = token;
        }
        return bestToken;
    }

    public FrameStatistics[] getFrameStatistics() {
        return null;
    }

    public int getStartFrame() {
        return 0;
    }

    public int getEndFrame() {
        return 0;
    }

    public List<Data> getDataFrames() {
        Token token = this.getBestToken();
        if (token == null) {
            return null;
        }
        LinkedList<Data> featureList = new LinkedList<Data>();
        do {
            Data feature;
            if ((feature = token.getData()) == null) continue;
            featureList.add(0, feature);
        } while ((token = token.getPredecessor()) != null);
        return featureList;
    }

    public String getBestResultNoFiller() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestFinalResultNoFiller() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestPronunciationResult() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath(false, true);
    }

    public String getTimedBestResult(boolean wantFiller, boolean wordTokenFirst) {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        if (wordTokenFirst) {
            return this.getTimedWordPath(token, wantFiller);
        }
        return this.getTimedWordTokenLastPath(token, wantFiller);
    }

    private String getTimedWordPath(Token token, boolean wantFiller) {
        StringBuilder sb = new StringBuilder();
        while (token != null && !token.isEmitting()) {
            token = token.getPredecessor();
        }
        if (token != null) {
            Data lastWordFirstFeature;
            Data lastFeature = lastWordFirstFeature = token.getData();
            for (token = token.getPredecessor(); token != null; token = token.getPredecessor()) {
                Data feature;
                if (token.isWord()) {
                    Word word = token.getWord();
                    if (wantFiller || !word.isFiller()) {
                        this.addWord(sb, word, (FloatData)lastFeature, (FloatData)lastWordFirstFeature);
                    }
                    lastWordFirstFeature = lastFeature;
                }
                if ((feature = token.getData()) == null) continue;
                lastFeature = feature;
            }
        }
        return sb.toString();
    }

    private String getTimedWordTokenLastPath(Token token, boolean wantFiller) {
        StringBuilder sb = new StringBuilder();
        Word word = null;
        Data lastFeature = null;
        Data lastWordFirstFeature = null;
        while (token != null) {
            Data feature;
            if (token.isWord()) {
                System.out.println("WordToken " + token.getWord() + " " + lastFeature);
                if (word != null && lastFeature != null) {
                    if (wantFiller || !word.isFiller()) {
                        this.addWord(sb, word, (FloatData)lastFeature, (FloatData)lastWordFirstFeature);
                    }
                    word = token.getWord();
                    lastWordFirstFeature = lastFeature;
                }
                word = token.getWord();
            }
            if ((feature = token.getData()) != null) {
                lastFeature = feature;
                if (lastWordFirstFeature == null) {
                    lastWordFirstFeature = lastFeature;
                }
            }
            token = token.getPredecessor();
        }
        return sb.toString();
    }

    private void addWord(StringBuilder sb, Word word, FloatData startFeature, FloatData endFeature) {
        float endTime;
        float startTime = startFeature == null ? -1.0f : (float)startFeature.getFirstSampleNumber() / (float)startFeature.getSampleRate();
        float f = endTime = endFeature == null ? -1.0f : (float)endFeature.getFirstSampleNumber() / (float)endFeature.getSampleRate();
        if (sb.length() > 0) {
            sb.insert(0, ' ');
        }
        sb.insert(0, word.getSpelling() + '(' + startTime + ',' + endTime + ')');
    }

    public String toString() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath();
    }

    void setFinal(boolean finalResult) {
        this.isFinal = finalResult;
    }

    public boolean validate() {
        boolean valid = true;
        for (Token token : this.activeList) {
            if (token.validate()) continue;
            valid = false;
            token.dumpTokenPath();
        }
        return valid;
    }

    public void setReferenceText(String ref) {
        this.reference = ref;
    }

    public String getReferenceText() {
        return this.reference;
    }
}

