/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.AbstractSausageMaker;
import edu.cmu.sphinx.result.ConfidenceResult;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.LatticeOptimizer;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.Sausage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PivotSausageMaker
extends AbstractSausageMaker {
    protected List<Node> sortedNodes;
    protected List<AbstractSausageMaker.Cluster> clusters;

    public Sausage makeSausage() {
        for (Node node : this.sortedNodes) {
            int newTime;
            int slot = this.findMostOverlappingSlot(node);
            AbstractSausageMaker.Cluster targetCluster = this.getCluster(slot);
            if (!this.containsAncestor(targetCluster, node)) {
                targetCluster.add(node);
                continue;
            }
            AbstractSausageMaker.Cluster newCluster = new AbstractSausageMaker.Cluster(node);
            targetCluster.endTime = newTime = (targetCluster.startTime + targetCluster.endTime) / 2;
            newCluster.startTime = newTime;
            this.clusters.add(slot + 1, newCluster);
        }
        return this.sausageFromClusters(this.clusters);
    }

    protected AbstractSausageMaker.Cluster getCluster(int i) {
        return this.clusters.get(i);
    }

    protected boolean containsAncestor(AbstractSausageMaker.Cluster c, Node n) {
        for (Node cNode : c.getElements()) {
            if (!cNode.isAncestorOf(n)) continue;
            return true;
        }
        return false;
    }

    protected int findMostOverlappingSlot(Node n) {
        int maxOverlap = Integer.MIN_VALUE;
        int bestCluster = -1;
        ListIterator<AbstractSausageMaker.Cluster> i = this.clusters.listIterator();
        i.next();
        while (i.hasNext()) {
            int index = i.nextIndex();
            if (!i.hasNext()) {
                return bestCluster;
            }
            AbstractSausageMaker.Cluster c = i.next();
            int overlap = PivotSausageMaker.getOverlap(n, c.startTime, c.endTime);
            if (overlap <= maxOverlap) continue;
            maxOverlap = overlap;
            bestCluster = index;
        }
        return bestCluster;
    }

    @Override
    public ConfidenceResult score(Result result) {
        this.lattice = new Lattice(result);
        LatticeOptimizer lop = new LatticeOptimizer(this.lattice);
        lop.optimize();
        this.lattice.computeNodePosteriors(this.languageWeight);
        List<Node> seedPath = this.lattice.getViterbiPath();
        this.sortedNodes = this.lattice.sortNodes();
        this.sortedNodes.removeAll(seedPath);
        this.clusters = new LinkedList<AbstractSausageMaker.Cluster>();
        for (Node n : seedPath) {
            this.clusters.add(new AbstractSausageMaker.Cluster(n));
        }
        return this.makeSausage();
    }
}

