/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.util.LogMath;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Node {
    private static int nodeCount;
    private String id;
    private Word word;
    private int beginTime = -1;
    private int endTime = -1;
    private List<Edge> enteringEdges = new ArrayList<Edge>();
    private List<Edge> leavingEdges = new ArrayList<Edge>();
    private double forwardScore;
    private double backwardScore;
    private double posterior;
    private Node bestPredecessor;
    private double viterbiScore;
    private Set<Node> descendants;

    protected Node(Word word, int beginTime, int endTime) {
        this(Node.getNextNodeId(), word, beginTime, endTime);
    }

    protected Node(String id, Word word, int beginTime, int endTime) {
        ++nodeCount;
        this.id = id;
        this.word = word;
        this.beginTime = beginTime;
        this.endTime = endTime;
        if (endTime != -1 && beginTime > endTime) {
            throw new Error("Begin time (" + beginTime + ") later than end time (" + endTime + ')');
        }
        this.forwardScore = LogMath.getLogZero();
        this.backwardScore = LogMath.getLogZero();
        this.posterior = LogMath.getLogZero();
    }

    protected static String getNextNodeId() {
        return Integer.toString(nodeCount);
    }

    protected boolean hasEdgeToNode(Node n) {
        return this.getEdgeToNode(n) != null;
    }

    public Edge getEdgeToNode(Node n) {
        for (Edge e : this.leavingEdges) {
            if (e.getToNode() != n) continue;
            return e;
        }
        return null;
    }

    protected boolean hasEdgeFromNode(Node n) {
        return this.getEdgeFromNode(n) != null;
    }

    public Edge getEdgeFromNode(Node n) {
        for (Edge e : this.enteringEdges) {
            if (e.getFromNode() != n) continue;
            return e;
        }
        return null;
    }

    protected boolean hasEquivalentEnteringEdges(Node n) {
        if (this.enteringEdges.size() != n.getEnteringEdges().size()) {
            return false;
        }
        for (Edge e : this.enteringEdges) {
            Node fromNode = e.getFromNode();
            if (n.hasEdgeFromNode(fromNode)) continue;
            return false;
        }
        return true;
    }

    public boolean hasEquivalentLeavingEdges(Node n) {
        if (this.leavingEdges.size() != n.getLeavingEdges().size()) {
            return false;
        }
        for (Edge e : this.leavingEdges) {
            Node toNode = e.getToNode();
            if (n.hasEdgeToNode(toNode)) continue;
            return false;
        }
        return true;
    }

    public Collection<Edge> getEnteringEdges() {
        return this.enteringEdges;
    }

    public Collection<Edge> getLeavingEdges() {
        return this.leavingEdges;
    }

    public Collection<Edge> getCopyOfEnteringEdges() {
        return new ArrayList<Edge>(this.enteringEdges);
    }

    public Collection<Edge> getCopyOfLeavingEdges() {
        return new ArrayList<Edge>(this.leavingEdges);
    }

    protected void addEnteringEdge(Edge e) {
        this.enteringEdges.add(e);
    }

    protected void addLeavingEdge(Edge e) {
        this.leavingEdges.add(e);
    }

    protected void removeEnteringEdge(Edge e) {
        this.enteringEdges.remove(e);
    }

    public void removeLeavingEdge(Edge e) {
        this.leavingEdges.remove(e);
    }

    public String getId() {
        return this.id;
    }

    public Word getWord() {
        return this.word;
    }

    public int getBeginTime() {
        if (this.beginTime == -1) {
            this.calculateBeginTime();
        }
        return this.beginTime;
    }

    public void setBeginTime(int beginTime) {
        if (beginTime > this.getEndTime()) {
            throw new Error("Attempting to set a begin time (" + beginTime + ") that is later than the end time (" + this.getEndTime() + ").");
        }
        this.beginTime = beginTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        if (this.getBeginTime() > endTime) {
            throw new Error("Attempting to set an end time (" + endTime + ") that is earlier than the start time (" + this.getBeginTime() + ").");
        }
        this.endTime = endTime;
    }

    public String toString() {
        return "Node(" + this.word.getSpelling() + ',' + this.getBeginTime() + '|' + this.getEndTime() + ')';
    }

    void dumpAISee(FileWriter f) throws IOException {
        String posterior = String.valueOf(this.getPosterior());
        if (this.getPosterior() == (double)LogMath.getLogZero()) {
            posterior = "log zero";
        }
        f.write("node: { title: \"" + this.id + "\" label: \"" + this.getWord() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + posterior + "]\" }\n");
    }

    public void dumpDot(FileWriter f) throws IOException {
        String posterior = String.valueOf(this.getPosterior());
        if (this.getPosterior() == (double)LogMath.getLogZero()) {
            posterior = "log zero";
        }
        String label = this.getWord().toString() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + posterior + ']';
        f.write("\tnode" + this.id + " [ label=\"" + label + "\" ]\n");
    }

    void dump(PrintWriter f) throws IOException {
        f.println("node: " + this.id + ' ' + this.word.getSpelling() + " p:" + this.getPosterior());
    }

    static void load(Lattice lattice, StringTokenizer tokens) {
        String id = tokens.nextToken();
        String label = tokens.nextToken();
        lattice.addNode(id, label, 0, 0);
    }

    public double getBackwardScore() {
        return this.backwardScore;
    }

    public void setBackwardScore(double backwardScore) {
        this.backwardScore = backwardScore;
    }

    public double getForwardScore() {
        return this.forwardScore;
    }

    public void setForwardScore(double forwardScore) {
        this.forwardScore = forwardScore;
    }

    public double getPosterior() {
        return this.posterior;
    }

    public void setPosterior(double posterior) {
        this.posterior = posterior;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Node && this.id.equals(((Node)obj).getId());
    }

    private void calculateBeginTime() {
        this.beginTime = 0;
        for (Edge edge : this.enteringEdges) {
            if (edge.getFromNode().getEndTime() <= this.beginTime) continue;
            this.beginTime = edge.getFromNode().getEndTime();
        }
    }

    public List<Node> getChildNodes() {
        LinkedList<Node> childNodes = new LinkedList<Node>();
        for (Edge edge : this.leavingEdges) {
            childNodes.add(edge.getToNode());
        }
        return childNodes;
    }

    protected void cacheDescendants() {
        this.descendants = new HashSet<Node>();
        this.cacheDescendantsHelper(this);
    }

    protected void cacheDescendantsHelper(Node n) {
        for (Node child : n.getChildNodes()) {
            if (this.descendants.contains(child)) continue;
            this.descendants.add(child);
            this.cacheDescendantsHelper(child);
        }
    }

    protected boolean isAncestorHelper(List<Node> children, Node node, Set<Node> seenNodes) {
        for (Node n : children) {
            if (seenNodes.contains(n)) continue;
            seenNodes.add(n);
            if (n.equals(node)) {
                return true;
            }
            if (!this.isAncestorHelper(n.getChildNodes(), node, seenNodes)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Node node) {
        if (this.descendants != null) {
            return this.descendants.contains(node);
        }
        if (this.equals(node)) {
            return true;
        }
        HashSet<Node> seenNodes = new HashSet<Node>();
        seenNodes.add(this);
        return this.isAncestorHelper(this.getChildNodes(), node, seenNodes);
    }

    public boolean hasAncestralRelationship(Node node) {
        return this.isAncestorOf(node) || node.isAncestorOf(this);
    }

    public boolean isEquivalent(Node other) {
        return this.word.getSpelling().equals(other.getWord().getSpelling()) && this.getEnteringEdges().size() == other.getEnteringEdges().size() && this.getLeavingEdges().size() == other.getLeavingEdges().size() && this.beginTime == other.getBeginTime() && this.endTime == other.getEndTime();
    }

    public Edge findEquivalentLeavingEdge(Edge edge) {
        for (Edge e : this.leavingEdges) {
            if (!e.isEquivalent(edge)) continue;
            return e;
        }
        return null;
    }

    public Node getBestPredecessor() {
        return this.bestPredecessor;
    }

    public void setBestPredecessor(Node bestPredecessor) {
        this.bestPredecessor = bestPredecessor;
    }

    public double getViterbiScore() {
        return this.viterbiScore;
    }

    public void setViterbiScore(double viterbiScore) {
        this.viterbiScore = viterbiScore;
    }
}

