/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.result.ConfidenceResult;
import edu.cmu.sphinx.result.ConfidenceScorer;
import edu.cmu.sphinx.result.ConfusionSet;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.LatticeOptimizer;
import edu.cmu.sphinx.result.Path;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.Sausage;
import edu.cmu.sphinx.result.SausageMaker;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.result.WordResultPath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MAPConfidenceScorer
implements ConfidenceScorer,
Configurable {
    @S4Double(defaultValue=1.0)
    public static final String PROP_LANGUAGE_WEIGHT_ADJUSTMENT = "languageWeightAdjustment";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DUMP_LATTICE = "dumpLattice";
    @S4Boolean(defaultValue=false)
    public static final String PROP_DUMP_SAUSAGE = "dumpSausage";
    private float languageWeightAdjustment;
    private boolean dumpLattice;
    private boolean dumpSausage;

    public MAPConfidenceScorer(float languageWeightAdjustment, boolean dumpLattice, boolean dumpSausage) {
        this.languageWeightAdjustment = languageWeightAdjustment;
        this.dumpLattice = dumpLattice;
        this.dumpSausage = dumpSausage;
    }

    public MAPConfidenceScorer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.languageWeightAdjustment = ps.getFloat(PROP_LANGUAGE_WEIGHT_ADJUSTMENT);
        this.dumpLattice = ps.getBoolean(PROP_DUMP_LATTICE);
        this.dumpSausage = ps.getBoolean(PROP_DUMP_SAUSAGE);
    }

    @Override
    public ConfidenceResult score(Result result) {
        Lattice lattice = new Lattice(result);
        LatticeOptimizer lop = new LatticeOptimizer(lattice);
        lop.optimize();
        lattice.computeNodePosteriors(this.languageWeightAdjustment);
        SausageMaker sm = new SausageMaker(lattice);
        Sausage s = sm.makeSausage();
        if (this.dumpLattice) {
            lattice.dumpAISee("mapLattice.gdl", "MAP Lattice");
        }
        if (this.dumpSausage) {
            s.dumpAISee("mapSausage.gdl", "MAP Sausage");
        }
        WordResultPath mapPath = new WordResultPath();
        List<Token> wordTokens = this.getWordTokens(result.getBestToken());
        int slot = 0;
        for (Token wordToken : wordTokens) {
            String word = wordToken.getWord().getSpelling();
            WordResult wr = null;
            ConfusionSet cs = null;
            while (slot < s.size() && wr == null) {
                cs = s.getConfusionSet(slot);
                wr = cs.getWordResult(word);
                if (wr != null) continue;
                ++slot;
            }
            if (wr == null) {
                cs.dump("Slot " + slot);
                throw new Error("Can't find WordResult in ConfidenceResult slot " + slot + " for word " + word);
            }
            mapPath.add(wr);
            ++slot;
        }
        return new MAPConfidenceResult(s, mapPath);
    }

    private List<Token> getWordTokens(Token lastToken) {
        LinkedList<Token> wordTokens = new LinkedList<Token>();
        for (Token token = lastToken; token != null; token = token.getPredecessor()) {
            if (!token.isWord()) continue;
            wordTokens.add(0, token);
        }
        return wordTokens;
    }

    class MAPConfidenceResult
    implements ConfidenceResult {
        private final ConfidenceResult sausage;
        private final Path mapPath;

        public MAPConfidenceResult(ConfidenceResult sausage, Path mapPath) {
            this.sausage = sausage;
            this.mapPath = mapPath;
        }

        @Override
        public Path getBestHypothesis() {
            return this.mapPath;
        }

        @Override
        public int size() {
            return this.sausage.size();
        }

        @Override
        public Iterator<ConfusionSet> iterator() {
            return this.sausage.iterator();
        }

        @Override
        public ConfusionSet getConfusionSet(int i) {
            return this.sausage.getConfusionSet(i);
        }
    }
}

