/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class GDLLatticeFactory {
    private GDLLatticeFactory() {
    }

    public static Lattice getLattice(String gdlFile, Dictionary dictionary) throws IOException {
        Lattice lattice = new Lattice();
        BufferedReader reader = new BufferedReader(new FileReader(gdlFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("node")) {
                GDLLatticeFactory.createNode(line, lattice, dictionary);
                continue;
            }
            if (!line.startsWith("edge")) continue;
            GDLLatticeFactory.createEdge(line, lattice);
        }
        return lattice;
    }

    private static void createNode(String line, Lattice lattice, Dictionary dictionary) {
        String[] text = line.split("\\s");
        String id = text[3].substring(1, text[3].length() - 1);
        String contents = text[5].substring(1);
        String posterior = text[6].substring(2, text[6].length() - 2);
        String word = contents.substring(0, contents.indexOf(91));
        contents = contents.substring(contents.indexOf(91) + 1);
        String start = contents.substring(0, contents.indexOf(44));
        String end = contents.substring(contents.indexOf(44) + 1);
        Node node = lattice.addNode(id, dictionary.getWord(word), Integer.parseInt(start), Integer.parseInt(end));
        node.setPosterior(Double.parseDouble(posterior));
        if (word.equals("<s>")) {
            lattice.setInitialNode(node);
        } else if (word.equals("</s>")) {
            lattice.setTerminalNode(node);
        }
    }

    private static void createEdge(String line, Lattice lattice) {
        String[] text = line.split("\\s");
        String src = text[3].substring(1, text[3].length() - 1);
        String dest = text[5].substring(1, text[5].length() - 1);
        String contents = text[7].substring(1, text[7].length() - 1);
        String[] scores = contents.split(",");
        lattice.addEdge(lattice.getNode(src), lattice.getNode(dest), Double.parseDouble(scores[0]), Double.parseDouble(scores[1]));
    }
}

