/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.ConfidenceScorer;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.result.Sausage;
import edu.cmu.sphinx.result.SimpleWordResult;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSausageMaker
implements ConfidenceScorer,
Configurable {
    @S4Double(defaultValue=1.0)
    public static final String PROP_LANGUAGE_WEIGHT = "languageWeight";
    protected float languageWeight;
    protected Lattice lattice;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.languageWeight = ps.getFloat(PROP_LANGUAGE_WEIGHT);
    }

    protected static int getOverlap(Node n, int startTime, int endTime) {
        return Math.min(n.getEndTime(), endTime) - Math.max(n.getBeginTime(), startTime);
    }

    protected static int getOverlap(Node n1, Node n2) {
        return Math.min(n1.getEndTime(), n2.getEndTime()) - Math.max(n1.getBeginTime(), n2.getBeginTime());
    }

    protected boolean hasOverlap(Cluster cluster1, Cluster cluster2) {
        return cluster1.startTime < cluster2.endTime && cluster2.startTime < cluster1.endTime;
    }

    protected double wordSubClusterProbability(List<Node> cluster, String word) {
        return this.clusterProbability(this.makeWordSubCluster(cluster, word));
    }

    protected double wordSubClusterProbability(Cluster cluster, String word) {
        return this.clusterProbability(this.makeWordSubCluster(cluster, word));
    }

    protected double clusterProbability(List<Node> cluster) {
        float p = LogMath.getLogZero();
        for (Node node : cluster) {
            p = this.lattice.getLogMath().addAsLinear(p, (float)node.getPosterior());
        }
        return p;
    }

    protected double clusterProbability(Cluster cluster) {
        return this.clusterProbability(cluster.elements);
    }

    protected List<Node> makeWordSubCluster(List<Node> cluster, String word) {
        ArrayList<Node> sub = new ArrayList<Node>();
        for (Node n : cluster) {
            if (!n.getWord().getSpelling().equals(word)) continue;
            sub.add(n);
        }
        return sub;
    }

    protected Cluster makeWordSubCluster(Cluster cluster, String word) {
        List<Node> l = this.makeWordSubCluster(cluster.elements, word);
        Cluster c = new Cluster(cluster.startTime, cluster.endTime);
        c.elements = l;
        return c;
    }

    protected void printClusters(List<Cluster> clusters) {
        ListIterator<Cluster> i = clusters.listIterator();
        while (i.hasNext()) {
            System.out.print("----cluster " + i.nextIndex() + " : ");
            System.out.println(i.next());
        }
        System.out.println("----");
    }

    protected Sausage sausageFromClusters(List<Cluster> clusters) {
        Sausage sausage = new Sausage(clusters.size());
        int index = 0;
        for (Cluster cluster : clusters) {
            HashSet<String> seenWords = new HashSet<String>();
            for (Node node : cluster) {
                Word word = node.getWord();
                if (seenWords.contains(word.getSpelling())) continue;
                seenWords.add(word.getSpelling());
                SimpleWordResult swr = new SimpleWordResult(node, this.wordSubClusterProbability(cluster, word.getSpelling()), this.lattice.getLogMath());
                sausage.addWordHypothesis(index, swr);
            }
            ++index;
        }
        sausage.fillInBlanks(this.lattice.getLogMath());
        return sausage;
    }

    class ClusterComparator
    implements Comparator<Cluster> {
        ClusterComparator() {
        }

        @Override
        public int compare(Cluster cluster1, Cluster cluster2) {
            for (Node n1 : cluster1) {
                for (Node n2 : cluster2) {
                    if (n1.isAncestorOf(n2)) {
                        return -1;
                    }
                    if (!n2.isAncestorOf(n1)) continue;
                    return 1;
                }
            }
            return 0;
        }
    }

    class Cluster
    implements Iterable<Node> {
        public int startTime;
        public int endTime;
        private List<Node> elements = new LinkedList<Node>();

        public Cluster(Node n) {
            this.startTime = n.getBeginTime();
            this.endTime = n.getEndTime();
            this.elements.add(n);
        }

        public Cluster(int start, int end) {
            this.startTime = start;
            this.endTime = end;
        }

        public void add(Node n) {
            if (n.getBeginTime() < this.startTime) {
                this.startTime = n.getBeginTime();
            }
            if (n.getEndTime() > this.endTime) {
                this.endTime = n.getEndTime();
            }
            this.elements.add(n);
        }

        public void add(Cluster c) {
            if (c.startTime < this.startTime) {
                this.startTime = c.startTime;
            }
            if (c.endTime > this.endTime) {
                this.endTime = c.endTime;
            }
            this.elements.addAll(c.getElements());
        }

        @Override
        public Iterator<Node> iterator() {
            return this.elements.iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("s: ").append(this.startTime).append(" e: ").append(this.endTime).append('[');
            for (Node node : this.elements) {
                sb.append(node).append(',');
            }
            if (!this.elements.isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append(']');
            return sb.toString();
        }

        public List<Node> getElements() {
            return this.elements;
        }

        public void setElements(List<Node> elements) {
            this.elements = elements;
        }
    }
}

