/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.research.parallel.ParallelToken;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class SameTimeTokensReader {
    private ListIterator<ParallelToken> listIterator;
    private int timeDifference;

    SameTimeTokensReader(int timeDiff) {
        this.timeDifference = timeDiff;
        System.out.println("MaxTimeDiff: " + this.timeDifference);
    }

    public void reset(List<ParallelToken> tokenList) {
        this.listIterator = tokenList.listIterator();
    }

    public boolean hasMoreTokens() {
        return this.listIterator.hasNext();
    }

    public boolean isSameTime(int time1, int time2) {
        return Math.abs(time1 - time2) <= this.timeDifference;
    }

    public List<ParallelToken> readNextSameTimeTokens() {
        LinkedList<ParallelToken> subList = new LinkedList<ParallelToken>();
        if (this.listIterator.hasNext()) {
            ParallelToken token = this.listIterator.next();
            subList.add(token);
            int lastCombineTime = token.getLastCombineTime();
            while (this.listIterator.hasNext()) {
                ParallelToken nextToken = this.listIterator.next();
                if (this.isSameTime(nextToken.getLastCombineTime(), lastCombineTime)) {
                    subList.add(nextToken);
                    continue;
                }
                this.listIterator.previous();
                break;
            }
        }
        return subList;
    }
}

