/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.research.parallel.CombineToken;
import edu.cmu.sphinx.research.parallel.ParallelToken;
import edu.cmu.sphinx.research.parallel.SameTimeTokensReader;
import edu.cmu.sphinx.research.parallel.ScoreCombiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SameTimeScoreCombiner
implements ScoreCombiner {
    private SameTimeTokensReader reader;
    private static Comparator<ParallelToken> combineTimeComparator;

    private static Comparator<ParallelToken> getCombineTimeComparator() {
        if (combineTimeComparator == null) {
            combineTimeComparator = new Comparator<ParallelToken>(){

                @Override
                public int compare(ParallelToken t1, ParallelToken t2) {
                    if (t1.getLastCombineTime() < t2.getLastCombineTime()) {
                        return -1;
                    }
                    if (t1.getLastCombineTime() == t2.getLastCombineTime()) {
                        return 0;
                    }
                    return 1;
                }
            };
        }
        return combineTimeComparator;
    }

    public SameTimeScoreCombiner(int timeDifference) {
        this.reader = new SameTimeTokensReader(timeDifference);
    }

    @Override
    public void combineScore(CombineToken combineToken) {
        ArrayList<ParallelToken> tokenList = new ArrayList<ParallelToken>(combineToken.getParallelTokens());
        Collections.sort(tokenList, SameTimeScoreCombiner.getCombineTimeComparator());
        double logHighestCombinedScore = Double.NEGATIVE_INFINITY;
        List<ParallelToken> highestList = null;
        this.reader.reset(tokenList);
        while (this.reader.hasMoreTokens()) {
            List<ParallelToken> sameTimeList = this.reader.readNextSameTimeTokens();
            double logCombinedScore = this.getCombinedScore(sameTimeList);
            if (!(logCombinedScore > logHighestCombinedScore) && logHighestCombinedScore != Double.NEGATIVE_INFINITY) continue;
            logHighestCombinedScore = logCombinedScore;
            highestList = sameTimeList;
        }
        assert (highestList != null && !highestList.isEmpty());
        for (ParallelToken token : highestList) {
            token.setCombinedScore((float)logHighestCombinedScore);
        }
        combineToken.clear();
        combineToken.addAll(highestList);
        combineToken.setCombinedScore((float)logHighestCombinedScore);
    }

    private double getCombinedScore(List<ParallelToken> sameTimeTokenList) {
        HashMap<String, ParallelToken> uniqueMap = new HashMap<String, ParallelToken>();
        for (ParallelToken token : sameTimeTokenList) {
            String modelName = token.getModelName();
            ParallelToken tokenInMap = (ParallelToken)uniqueMap.get(modelName);
            if (tokenInMap == null) {
                uniqueMap.put(modelName, token);
                continue;
            }
            if (!(token.getFeatureScore() > tokenInMap.getFeatureScore())) continue;
            uniqueMap.put(modelName, token);
        }
        sameTimeTokenList.clear();
        assert (sameTimeTokenList.isEmpty());
        double logTotalScore = 0.0;
        for (ParallelToken pToken : uniqueMap.values()) {
            sameTimeTokenList.add(pToken);
            double logScore = pToken.getFeatureScore() * pToken.getEta();
            logTotalScore += logScore;
        }
        return logTotalScore;
    }

    private void checkSameTime(List<ParallelToken> tokenList) {
        System.out.print("SameTimeList: ");
        for (ParallelToken token : tokenList) {
            System.out.print(this.tokenToString(token));
        }
        System.out.println();
    }

    private String tokenToString(ParallelToken token) {
        return " (" + token.getLastCombineTime() + ',' + token.getModelName() + ',' + token.getFeatureScore() + ") ";
    }
}

