/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.research.parallel.CombineToken;
import edu.cmu.sphinx.research.parallel.ParallelToken;
import edu.cmu.sphinx.research.parallel.ScoreCombiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SameStampScoreCombiner
implements ScoreCombiner {
    public List<ParallelToken> removeTokensByStamp(List<ParallelToken> tokenList, String stamp) {
        LinkedList<ParallelToken> returnList = new LinkedList<ParallelToken>();
        Iterator<ParallelToken> i = tokenList.iterator();
        while (i.hasNext()) {
            ParallelToken token = i.next();
            if (!token.getLastCombineStamp().equals(stamp)) continue;
            returnList.add(token);
            i.remove();
        }
        return returnList;
    }

    @Override
    public void combineScore(CombineToken combineToken) {
        ArrayList<ParallelToken> tokenList = new ArrayList<ParallelToken>(combineToken.getParallelTokens());
        double logHighestCombinedScore = Double.NEGATIVE_INFINITY;
        List<ParallelToken> highestList = null;
        while (!tokenList.isEmpty()) {
            ParallelToken firstToken = (ParallelToken)tokenList.get(0);
            List<ParallelToken> sameStampList = this.removeTokensByStamp(tokenList, firstToken.getLastCombineStamp());
            double logCombinedScore = this.getCombinedScore(sameStampList);
            if (!(logCombinedScore > logHighestCombinedScore) && logHighestCombinedScore != Double.NEGATIVE_INFINITY) continue;
            logHighestCombinedScore = logCombinedScore;
            highestList = sameStampList;
        }
        assert (highestList != null && highestList.size() > 1);
        for (ParallelToken token : highestList) {
            token.setCombinedScore((float)logHighestCombinedScore);
        }
        combineToken.clear();
        combineToken.addAll(highestList);
        combineToken.setCombinedScore((float)logHighestCombinedScore);
    }

    private double getCombinedScore(List<ParallelToken> sameStampTokenList) {
        HashMap<String, ParallelToken> uniqueMap = new HashMap<String, ParallelToken>();
        for (ParallelToken token : sameStampTokenList) {
            String modelName = token.getModelName();
            ParallelToken tokenInMap = (ParallelToken)uniqueMap.get(modelName);
            if (tokenInMap == null) {
                uniqueMap.put(modelName, token);
                continue;
            }
            if (!(token.getFeatureScore() > tokenInMap.getFeatureScore())) continue;
            uniqueMap.put(modelName, token);
        }
        sameStampTokenList.clear();
        assert (sameStampTokenList.isEmpty());
        double logTotalScore = 0.0;
        for (ParallelToken pToken : uniqueMap.values()) {
            sameStampTokenList.add(pToken);
            double logScore = pToken.getFeatureScore() * pToken.getEta();
            logTotalScore += logScore;
        }
        return logTotalScore;
    }
}

