/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.flat.FlatLinguist;
import edu.cmu.sphinx.linguist.flat.SentenceHMMState;
import edu.cmu.sphinx.linguist.flat.UnitState;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.research.parallel.CombineState;
import edu.cmu.sphinx.research.parallel.FeatureStream;
import edu.cmu.sphinx.research.parallel.ParallelHMMStateState;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParallelSimpleLinguist
extends FlatLinguist {
    @S4Integer(defaultValue=0)
    public static final String PROP_STACK_CAPACITY = "tokenStackCapacity";
    @S4String(defaultValue="unit")
    public static final String PROP_TIE_LEVEL = "tieLevel";
    @S4ComponentList(type=FeatureStream.class)
    public static final String PROP_FEATURE_STREAMS = "featureStreams";
    private List<FeatureStream> featureStreams;
    private int tokenStackCapacity;
    private String tieLevel;
    private static final float logOne = LogMath.getLogOne();

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.tokenStackCapacity = ps.getInt(PROP_STACK_CAPACITY);
        this.tieLevel = ps.getString(PROP_TIE_LEVEL);
    }

    @Override
    protected void setupAcousticModel(PropertySheet ps) throws PropertyException {
        this.featureStreams = ps.getComponentList(PROP_FEATURE_STREAMS, FeatureStream.class);
    }

    @Override
    protected void allocateAcousticModel() throws IOException {
        for (FeatureStream stream : this.featureStreams) {
            stream.getAcousticModel().allocate();
        }
    }

    protected void freeAcousticModels() {
        for (FeatureStream stream : this.featureStreams) {
            stream.freeAcousticModel();
        }
    }

    public Iterator<FeatureStream> getFeatureStreams() {
        return this.featureStreams.iterator();
    }

    @Override
    protected FlatLinguist.GState createGState(GrammarNode grammarNode) {
        return new ParallelGState(grammarNode);
    }

    class ParallelGState
    extends FlatLinguist.GState {
        ParallelGState(GrammarNode node) {
            super(node);
        }

        @Override
        protected int getLeftContextSize() {
            FeatureStream stream = (FeatureStream)ParallelSimpleLinguist.this.featureStreams.get(0);
            return stream.getAcousticModel().getLeftContextSize();
        }

        @Override
        protected int getRightContextSize() {
            FeatureStream stream = (FeatureStream)ParallelSimpleLinguist.this.featureStreams.get(0);
            return stream.getAcousticModel().getRightContextSize();
        }

        @Override
        protected SentenceHMMState expandUnit(UnitState unit) {
            SentenceHMMState tail = null;
            if (ParallelSimpleLinguist.this.tieLevel.equals("unit")) {
                tail = this.getTiedHMMs(unit);
            } else if (ParallelSimpleLinguist.this.tieLevel.equals("state")) {
                tail = this.getTiedHMMStates(unit);
            }
            if (unit.getUnit().isSilence()) {
                this.attachState(tail, unit, LogMath.getLogOne(), ParallelSimpleLinguist.this.getLogSilenceInsertionProbability());
            }
            return tail;
        }

        private SentenceHMMState getTiedHMMs(UnitState unitState) {
            CombineState combineState = new CombineState(unitState.getParent(), unitState.getWhich());
            for (FeatureStream stream : ParallelSimpleLinguist.this.featureStreams) {
                AcousticModel model = stream.getAcousticModel();
                HMM hmm = model.lookupNearestHMM(unitState.getUnit(), unitState.getPosition(), false);
                ParallelHMMStateState firstHMMState = new ParallelHMMStateState(unitState, stream, hmm.getInitialState(), ParallelSimpleLinguist.this.tokenStackCapacity);
                firstHMMState.setColor(SentenceHMMState.Color.GREEN);
                this.attachState(unitState, firstHMMState, logOne, logOne);
                HashMap<HMMState, ParallelHMMStateState> hmmStates = new HashMap<HMMState, ParallelHMMStateState>();
                hmmStates.put(firstHMMState.getHMMState(), firstHMMState);
                SentenceHMMState lastState = this.expandParallelHMMTree(firstHMMState, stream, hmmStates);
                this.attachState(lastState, combineState, logOne, logOne);
            }
            return combineState;
        }

        private SentenceHMMState expandParallelHMMTree(ParallelHMMStateState hmmStateState, FeatureStream stream, Map<HMMState, ParallelHMMStateState> expandedStates) {
            SentenceHMMState lastState = hmmStateState;
            HMMState hmmState = hmmStateState.getHMMState();
            for (HMMStateArc arc : hmmState.getSuccessors()) {
                ParallelHMMStateState nextState;
                HMMState nextHmmState = arc.getHMMState();
                if (nextHmmState == hmmState) {
                    this.attachState(hmmStateState, hmmStateState, logOne, arc.getLogProbability());
                    lastState = hmmStateState;
                    continue;
                }
                if (expandedStates.containsKey(nextHmmState)) {
                    nextState = expandedStates.get(nextHmmState);
                } else {
                    nextState = new ParallelHMMStateState(hmmStateState.getParent(), stream, nextHmmState, ParallelSimpleLinguist.this.tokenStackCapacity);
                    expandedStates.put(nextHmmState, nextState);
                }
                nextState.setColor(SentenceHMMState.Color.GREEN);
                this.attachState(hmmStateState, nextState, logOne, arc.getLogProbability());
                lastState = this.expandParallelHMMTree(nextState, stream, expandedStates);
            }
            return lastState;
        }

        private SentenceHMMState getTiedHMMStates(UnitState unitState) {
            HMM[] hmms = new HMM[ParallelSimpleLinguist.this.featureStreams.size()];
            int s = 0;
            for (FeatureStream stream : ParallelSimpleLinguist.this.featureStreams) {
                hmms[s] = stream.getAcousticModel().lookupNearestHMM(unitState.getUnit(), unitState.getPosition(), false);
            }
            SentenceHMMState lastState = this.getHMMTiedStates(hmms, unitState);
            return lastState;
        }

        private SentenceHMMState getHMMTiedStates(HMM[] hmms, UnitState unitState) {
            int i;
            CombineState lastState = new CombineState(unitState, 0);
            HMMStateArc[] arcs = new HMMStateArc[ParallelSimpleLinguist.this.featureStreams.size()];
            for (i = 0; i < hmms.length; ++i) {
                HMMState hmmState = hmms[i].getInitialState();
                FeatureStream stream = (FeatureStream)ParallelSimpleLinguist.this.featureStreams.get(i);
                ParallelHMMStateState firstHMMState = new ParallelHMMStateState(unitState, stream, hmmState, ParallelSimpleLinguist.this.tokenStackCapacity);
                firstHMMState.setColor(SentenceHMMState.Color.GREEN);
                this.attachState(unitState, firstHMMState, logOne, logOne);
                this.attachState(firstHMMState, lastState, logOne, logOne);
                HMMStateArc selfTransition = this.getSelfTransition(hmmState);
                if (selfTransition != null) {
                    this.attachState(lastState, firstHMMState, logOne, selfTransition.getLogProbability());
                }
                arcs[i] = this.getTransitionToNextState(hmmState);
            }
            for (i = 1; i <= hmms[0].getOrder(); ++i) {
                CombineState combineState = new CombineState(unitState, i);
                for (int a = 0; a < arcs.length; ++a) {
                    HMMStateArc arc = arcs[a];
                    HMMState hmmState = arc.getHMMState();
                    FeatureStream stream = (FeatureStream)ParallelSimpleLinguist.this.featureStreams.get(a);
                    ParallelHMMStateState hmmStateState = new ParallelHMMStateState(unitState, stream, hmmState, ParallelSimpleLinguist.this.tokenStackCapacity);
                    hmmStateState.setColor(SentenceHMMState.Color.GREEN);
                    this.attachState(lastState, hmmStateState, logOne, arc.getLogProbability());
                    this.attachState(hmmStateState, combineState, logOne, logOne);
                    HMMStateArc selfTransition = this.getSelfTransition(hmmState);
                    if (selfTransition != null) {
                        this.attachState(combineState, hmmStateState, logOne, selfTransition.getLogProbability());
                    }
                    arcs[a] = this.getTransitionToNextState(hmmState);
                }
                lastState = combineState;
            }
            return lastState;
        }

        private HMMStateArc getSelfTransition(HMMState hmmState) {
            for (HMMStateArc arc : hmmState.getSuccessors()) {
                HMMState nextHmmState = arc.getHMMState();
                if (nextHmmState != hmmState) continue;
                return arc;
            }
            return null;
        }

        private HMMStateArc getTransitionToNextState(HMMState hmmState) {
            for (HMMStateArc arc : hmmState.getSuccessors()) {
                HMMState nextHmmState = arc.getHMMState();
                if (nextHmmState == hmmState) continue;
                return arc;
            }
            return null;
        }
    }
}

