/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.dictionary.WordClassification;
import edu.cmu.sphinx.linguist.language.classes.ClassMap;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.IOException;

public class ClassPresentingDictionary
implements Dictionary {
    @S4Component(type=ClassMap.class)
    public static final String PROP_CLASS_MAP = "classMap";
    @S4Component(type=Dictionary.class)
    public static final String PROP_WORD_DICTIONARY = "wordDictionary";
    private boolean allocated = false;
    private Dictionary wordDictionary;
    private ClassMap classMap;

    public ClassPresentingDictionary(ClassMap classMap, Dictionary wordDictionary) {
        this.classMap = classMap;
        this.wordDictionary = wordDictionary;
    }

    public ClassPresentingDictionary() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.classMap = (ClassMap)ps.getComponent(PROP_CLASS_MAP);
        this.wordDictionary = (Dictionary)ps.getComponent(PROP_WORD_DICTIONARY);
    }

    @Override
    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.wordDictionary.allocate();
            this.classMap.allocate();
        }
    }

    @Override
    public void deallocate() {
        this.allocated = false;
        this.wordDictionary = null;
    }

    @Override
    public Word getWord(String text) {
        Word word = this.classMap.getClassAsWord(text);
        return word != null ? word : this.wordDictionary.getWord(text);
    }

    @Override
    public Word getSentenceStartWord() {
        return this.wordDictionary.getSentenceStartWord();
    }

    @Override
    public Word getSentenceEndWord() {
        return this.wordDictionary.getSentenceEndWord();
    }

    @Override
    public Word getSilenceWord() {
        return this.wordDictionary.getSilenceWord();
    }

    @Override
    public WordClassification[] getPossibleWordClassifications() {
        return this.wordDictionary.getPossibleWordClassifications();
    }

    @Override
    public Word[] getFillerWords() {
        return this.wordDictionary.getFillerWords();
    }

    public String toString() {
        return "Word dictionary:\n" + this.wordDictionary.toString() + "Classes:\n" + this.classMap.toString();
    }
}

