/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.classes;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.classes.ClassProbability;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassMap
implements Configurable {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4String
    public static final String PROP_CLASS_DEFS_LOCATION = "classDefsLocation";
    private Logger logger;
    private boolean allocated;
    private URL classDefsLocation;
    private LogMath logMath;
    private Map<String, Word> classVocabulary = new HashMap<String, Word>();
    private Map<String, ClassProbability> wordToClassProbabilities = new HashMap<String, ClassProbability>();
    private final HashMap<String, Set<String>> classToWord = new HashMap();

    public ClassMap(URL classDefsLocation, LogMath logMath) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.classDefsLocation = classDefsLocation;
        this.logMath = logMath;
    }

    public ClassMap() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        if (this.allocated) {
            throw new RuntimeException("Can't change properties after allocation");
        }
        this.classDefsLocation = ConfigurationManagerUtils.getResource(PROP_CLASS_DEFS_LOCATION, ps);
        this.logMath = (LogMath)ps.getComponent(PROP_LOG_MATH);
    }

    public void allocate() throws IOException {
        if (!this.allocated) {
            this.allocated = true;
            this.loadClassDefs();
        }
    }

    public void deallocate() {
        this.allocated = false;
        this.wordToClassProbabilities = null;
        this.classVocabulary = null;
    }

    public ClassProbability getClassProbability(String word) {
        return this.wordToClassProbabilities.get(word);
    }

    public Word getClassAsWord(String text) {
        return this.classVocabulary.get(text);
    }

    public Set<String> getWordsInClass(String className) {
        return this.classToWord.get(className);
    }

    private void loadClassDefs() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.classDefsLocation.openStream()));
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f=");
            if (st.countTokens() != 3) {
                throw new IOException("corrupt word to class def: " + line + "; " + st.countTokens());
            }
            String className = st.nextToken().toLowerCase();
            float linearProb = Float.parseFloat(st.nextToken());
            String word = st.nextToken().toLowerCase();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(word + " --> " + className + " " + linearProb);
            }
            this.wordToClassProbabilities.put(word, new ClassProbability(className, this.logMath.linearToLog(linearProb)));
            this.classVocabulary.put(className, new Word(className, null, false));
            this.addWordInClass(className, word);
        }
        reader.close();
        this.checkClasses();
        this.logger.info("Loaded word to class mappings for " + this.wordToClassProbabilities.size() + " words");
    }

    private void checkClasses() {
        HashMap<String, Float> sums = new HashMap<String, Float>();
        for (ClassProbability classProbability : this.wordToClassProbabilities.values()) {
            Float sum = (Float)sums.get(classProbability.getClassName());
            if (sum == null) {
                sums.put(classProbability.getClassName(), Float.valueOf(0.0f));
                continue;
            }
            sums.put(classProbability.getClassName(), Float.valueOf((float)this.logMath.logToLinear(classProbability.getLogProbability()) + sum.floatValue()));
        }
        for (Map.Entry entry : sums.entrySet()) {
            if (!(Math.abs(1.0 - (double)((Float)entry.getValue()).floatValue()) > 0.001)) continue;
            this.logger.warning("Word probabilities for class " + (String)entry.getKey() + " sum to " + entry.getValue());
        }
    }

    private void addWordInClass(String className, String word) {
        Set<String> words = this.classToWord.get(className);
        if (words == null) {
            words = new HashSet<String>();
            this.classToWord.put(className, words);
        }
        words.add(word);
    }
}

