/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.dictionary;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.FastDictionary;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MappingDictionary
extends FastDictionary
implements Dictionary {
    @S4String(mandatory=true, defaultValue="")
    public static final String PROP_MAP_FILE = "mapFile";
    private URL mappingFile;
    private final Map<String, String> mapping = new HashMap<String, String>();

    public MappingDictionary(URL mappingFile, URL wordDictionaryFile, URL fillerDictionaryFile, List<URL> addendaUrlList, boolean addSilEndingPronunciation, String wordReplacement, boolean allowMissingWords, boolean createMissingWords, UnitManager unitManager) {
        super(wordDictionaryFile, fillerDictionaryFile, addendaUrlList, addSilEndingPronunciation, wordReplacement, allowMissingWords, createMissingWords, unitManager);
        this.mappingFile = mappingFile;
    }

    public MappingDictionary() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.mappingFile = ConfigurationManagerUtils.getResource(PROP_MAP_FILE, ps);
    }

    @Override
    public void allocate() throws IOException {
        super.allocate();
        if (!this.mappingFile.getFile().equals("")) {
            this.loadMapping(this.mappingFile.openStream());
        }
    }

    @Override
    protected Unit getCIUnit(String name, boolean isFiller) {
        if (this.mapping.containsKey(name)) {
            name = this.mapping.get(name);
        }
        return this.unitManager.getUnit(name, isFiller, Context.EMPTY_CONTEXT);
    }

    protected void loadMapping(InputStream inputStream) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 2) {
                throw new IOException("Wrong file format");
            }
            this.mapping.put(st.nextToken(), st.nextToken());
        }
        br.close();
        isr.close();
        inputStream.close();
    }
}

