/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.LeftRightContext;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.GaussianMixture;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.HMMManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Loader;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Pool;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneSequence;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sphinx3Loader
implements Loader {
    @S4Component(type=LogMath.class)
    public static final String PROP_LOG_MATH = "logMath";
    @S4Component(type=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4String(mandatory=true)
    public static final String PROP_LOCATION = "location";
    @S4String(mandatory=false, defaultValue="mdef")
    public static final String PROP_MODEL = "modelDefinition";
    @S4String(mandatory=false, defaultValue="")
    public static final String PROP_DATA_LOCATION = "dataLocation";
    @S4Boolean(defaultValue=true)
    public static final String PROP_USE_CD_UNITS = "useCDUnits";
    @S4Double(defaultValue=0.0)
    public static final String PROP_MC_FLOOR = "MixtureComponentScoreFloor";
    @S4Double(defaultValue=9.999999747378752E-5)
    public static final String PROP_VARIANCE_FLOOR = "varianceFloor";
    @S4Double(defaultValue=1.0000000116860974E-7)
    public static final String PROP_MW_FLOOR = "mixtureWeightFloor";
    protected static final String FILLER = "filler";
    protected static final String SILENCE_CIPHONE = "SIL";
    protected static final int BYTE_ORDER_MAGIC = 287454020;
    public static final String MODEL_VERSION = "0.3";
    private static final int CONTEXT_SIZE = 1;
    protected Pool<float[]> meansPool;
    protected Pool<float[]> variancePool;
    protected Pool<float[][]> transitionsPool;
    protected Pool<float[]> mixtureWeightsPool;
    private Pool<float[][]> meanTransformationMatrixPool;
    private Pool<float[]> meanTransformationVectorPool;
    private Pool<float[][]> varianceTransformationMatrixPool;
    private Pool<float[]> varianceTransformationVectorPool;
    protected float[][] transformMatrix;
    protected Pool<Senone> senonePool;
    private Map<String, Unit> contextIndependentUnits;
    private HMMManager hmmManager;
    protected LogMath logMath;
    private UnitManager unitManager;
    private boolean swap;
    private static final String DENSITY_FILE_VERSION = "1.0";
    private static final String MIXW_FILE_VERSION = "1.0";
    private static final String TMAT_FILE_VERSION = "1.0";
    private static final String TRANSFORM_FILE_VERSION = "0.1";
    protected Logger logger;
    private URL location;
    protected String model;
    protected String dataLocation;
    protected float distFloor;
    protected float mixtureWeightFloor;
    protected float varianceFloor;
    protected boolean useCDUnits;
    private boolean loaded;
    private long calculatedCheckSum = 0L;

    public Sphinx3Loader(URL location, String model, String dataLocation, LogMath logMath, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, boolean useCDUnits) {
        this.init(location, model, dataLocation, logMath, unitManager, distFloor, mixtureWeightFloor, varianceFloor, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    public Sphinx3Loader(String location, String model, String dataLocation, LogMath logMath, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, boolean useCDUnits) throws MalformedURLException, ClassNotFoundException {
        this.init(ConfigurationManagerUtils.resourceToURL(location), model, dataLocation, logMath, unitManager, distFloor, mixtureWeightFloor, varianceFloor, useCDUnits, Logger.getLogger(this.getClass().getName()));
    }

    protected void init(URL location, String model, String dataLocatoin, LogMath logMath, UnitManager unitManager, float distFloor, float mixtureWeightFloor, float varianceFloor, boolean useCDUnits, Logger logger) {
        this.location = location;
        this.logger = logger;
        this.model = model;
        this.dataLocation = dataLocatoin;
        this.logMath = logMath;
        this.unitManager = unitManager;
        this.distFloor = distFloor;
        this.mixtureWeightFloor = mixtureWeightFloor;
        this.varianceFloor = varianceFloor;
        this.useCDUnits = useCDUnits;
    }

    public Sphinx3Loader() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.init(ConfigurationManagerUtils.getResource(PROP_LOCATION, ps), ps.getString(PROP_MODEL), ps.getString(PROP_DATA_LOCATION), (LogMath)ps.getComponent(PROP_LOG_MATH), (UnitManager)ps.getComponent(PROP_UNIT_MANAGER), ps.getFloat(PROP_MC_FLOOR), ps.getFloat(PROP_MW_FLOOR), ps.getFloat(PROP_VARIANCE_FLOOR), ps.getBoolean(PROP_USE_CD_UNITS), ps.getLogger());
    }

    protected InputStream getDataStream(String path) throws IOException, URISyntaxException {
        return new URL(this.location.toURI().toString() + "/" + path).openStream();
    }

    @Override
    public void load() throws IOException {
        if (!this.loaded) {
            TimerPool.getTimer(this, "Load AM").start();
            this.hmmManager = new HMMManager();
            this.contextIndependentUnits = new LinkedHashMap<String, Unit>();
            this.meanTransformationMatrixPool = null;
            this.meanTransformationVectorPool = null;
            this.varianceTransformationMatrixPool = null;
            this.varianceTransformationVectorPool = null;
            this.transformMatrix = null;
            try {
                this.loadModelFiles(this.model);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.loaded = true;
            TimerPool.getTimer(this, "Load AM").stop();
        }
    }

    protected HMMManager getHmmManager() {
        return this.hmmManager;
    }

    protected Pool<float[][]> getMatrixPool() {
        return this.transitionsPool;
    }

    protected Pool<float[]> getMixtureWeightsPool() {
        return this.mixtureWeightsPool;
    }

    protected void loadModelFiles(String modelDef) throws IOException, URISyntaxException {
        this.logger.config("Loading Sphinx3 acoustic model: " + modelDef);
        this.logger.config("    modelName: " + this.model);
        this.logger.config("    dataLocation   : " + this.dataLocation);
        this.meansPool = this.loadDensityFile(this.dataLocation + "means", -3.4028235E38f);
        this.variancePool = this.loadDensityFile(this.dataLocation + "variances", this.varianceFloor);
        this.mixtureWeightsPool = this.loadMixtureWeights(this.dataLocation + "mixture_weights", this.mixtureWeightFloor);
        this.transitionsPool = this.loadTransitionMatrices(this.dataLocation + "transition_matrices");
        this.transformMatrix = this.loadTransformMatrix(this.dataLocation + "feature_transform");
        this.senonePool = this.createSenonePool(this.distFloor, this.varianceFloor);
        InputStream modelStream = this.getDataStream(this.model);
        if (modelStream == null) {
            throw new IOException("can't find modelDef " + this.model);
        }
        this.loadHMMPool(this.useCDUnits, modelStream, this.model);
    }

    @Override
    public Map<String, Unit> getContextIndependentUnits() {
        return this.contextIndependentUnits;
    }

    protected Pool<Senone> createSenonePool(float distFloor, float varianceFloor) {
        Pool<Senone> pool = new Pool<Senone>("senones");
        int numMixtureWeights = this.mixtureWeightsPool.size();
        int numMeans = this.meansPool.size();
        int numVariances = this.variancePool.size();
        int numGaussiansPerSenone = this.mixtureWeightsPool.getFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, 0);
        int numSenones = this.mixtureWeightsPool.getFeature(Pool.Feature.NUM_SENONES, 0);
        int numStreams = this.mixtureWeightsPool.getFeature(Pool.Feature.NUM_STREAMS, 0);
        int whichGaussian = 0;
        this.logger.fine("Senones " + numSenones);
        this.logger.fine("Gaussians Per Senone " + numGaussiansPerSenone);
        this.logger.fine("MixtureWeights " + numMixtureWeights);
        this.logger.fine("Means " + numMeans);
        this.logger.fine("Variances " + numVariances);
        assert (numGaussiansPerSenone > 0);
        assert (numMixtureWeights == numSenones);
        assert (numVariances == numSenones * numGaussiansPerSenone);
        assert (numMeans == numSenones * numGaussiansPerSenone);
        float[][] meansTransformationMatrix = this.meanTransformationMatrixPool == null ? (float[][])null : this.meanTransformationMatrixPool.get(0);
        float[] meansTransformationVector = this.meanTransformationVectorPool == null ? null : this.meanTransformationVectorPool.get(0);
        float[][] varianceTransformationMatrix = this.varianceTransformationMatrixPool == null ? (float[][])null : this.varianceTransformationMatrixPool.get(0);
        float[] varianceTransformationVector = this.varianceTransformationVectorPool == null ? null : this.varianceTransformationVectorPool.get(0);
        for (int i = 0; i < numSenones; ++i) {
            MixtureComponent[] mixtureComponents = new MixtureComponent[numGaussiansPerSenone * numStreams];
            for (int j = 0; j < numGaussiansPerSenone; ++j) {
                mixtureComponents[j] = new MixtureComponent(this.logMath, this.meansPool.get(whichGaussian), meansTransformationMatrix, meansTransformationVector, this.variancePool.get(whichGaussian), varianceTransformationMatrix, varianceTransformationVector, distFloor, varianceFloor);
                ++whichGaussian;
            }
            GaussianMixture senone = new GaussianMixture(this.logMath, this.mixtureWeightsPool.get(i), mixtureComponents, i);
            pool.put(i, senone);
        }
        return pool;
    }

    protected Pool<float[]> loadDensityFile(String path, float floor) throws IOException, URISyntaxException {
        Properties props = new Properties();
        int blockSize = 0;
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        int numStates = this.readInt(dis);
        int numStreams = this.readInt(dis);
        int numGaussiansPerState = this.readInt(dis);
        int[] vectorLength = new int[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            vectorLength[i] = this.readInt(dis);
        }
        int rawLength = this.readInt(dis);
        this.logger.fine("Number of states " + numStates);
        this.logger.fine("Number of streams " + numStreams);
        this.logger.fine("Number of gaussians per state " + numGaussiansPerState);
        this.logger.fine("Vector length " + vectorLength.length);
        this.logger.fine("Raw length " + rawLength);
        for (int i = 0; i < numStreams; ++i) {
            blockSize += vectorLength[i];
        }
        assert (rawLength == numGaussiansPerState * blockSize * numStates);
        Pool<float[]> pool = new Pool<float[]>(path);
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
        pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStreams; ++j) {
                for (int k = 0; k < numGaussiansPerState; ++k) {
                    float[] density = this.readFloatArray(dis, vectorLength[j]);
                    Utilities.floorData(density, floor);
                    pool.put(i * numStreams * numGaussiansPerState + j * numGaussiansPerState + k, density);
                }
            }
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return pool;
    }

    protected DataInputStream readS3BinaryHeader(String path, Properties props) throws IOException, URISyntaxException {
        String name;
        InputStream inputStream = this.getDataStream(path);
        if (inputStream == null) {
            throw new IOException("Can't open " + path);
        }
        DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream));
        String id = this.readWord(dis);
        if (!id.equals("s3")) {
            throw new IOException("Not proper s3 binary file " + path);
        }
        while ((name = this.readWord(dis)) != null && !name.equals("endhdr")) {
            String value = this.readWord(dis);
            props.setProperty(name, value);
        }
        int byteOrderMagic = dis.readInt();
        if (byteOrderMagic == 287454020) {
            this.logger.fine("Not swapping " + path);
            this.swap = false;
        } else if (Utilities.swapInteger(byteOrderMagic) == 287454020) {
            this.logger.fine("Swapping  " + path);
            this.swap = true;
        } else {
            throw new IOException("Corrupted S3 file " + path);
        }
        return dis;
    }

    String readWord(DataInputStream dis) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isWhitespace(c = this.readChar(dis))) {
        }
        do {
            sb.append(c);
        } while (!Character.isWhitespace(c = this.readChar(dis)));
        return sb.toString();
    }

    private char readChar(DataInputStream dis) throws IOException {
        return (char)dis.readByte();
    }

    private void resetChecksum() {
        this.calculatedCheckSum = 0L;
    }

    private void validateChecksum(DataInputStream dis, boolean doCheckSum) throws IOException {
        if (!doCheckSum) {
            return;
        }
        int oldCheckSum = (int)this.calculatedCheckSum;
        int checkSum = this.readInt(dis);
        if (checkSum != oldCheckSum) {
            throw new IOException("Invalid checksum " + Long.toHexString(this.calculatedCheckSum) + " must be " + Integer.toHexString(checkSum));
        }
    }

    protected int readInt(DataInputStream dis) throws IOException {
        int val = this.swap ? Utilities.readLittleEndianInt(dis) : dis.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)val & 0xFFFFFFFFL;
        return val;
    }

    protected float readFloat(DataInputStream dis) throws IOException {
        int val = this.swap ? Utilities.readLittleEndianInt(dis) : dis.readInt();
        this.calculatedCheckSum = (this.calculatedCheckSum << 20 | this.calculatedCheckSum >> 12) + (long)val & 0xFFFFFFFFL;
        return Float.intBitsToFloat(val);
    }

    protected float[] readFloatArray(DataInputStream dis, int size) throws IOException {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readFloat(dis);
        }
        return data;
    }

    protected void loadHMMPool(boolean useCDUnits, InputStream inputStream, String path) throws IOException {
        ExtendedStreamTokenizer est = new ExtendedStreamTokenizer(inputStream, 35, false);
        this.logger.fine("Loading HMM file from: " + path);
        est.expectString(MODEL_VERSION);
        int numBase = est.getInt("numBase");
        est.expectString("n_base");
        int numTri = est.getInt("numTri");
        est.expectString("n_tri");
        int numStateMap = est.getInt("numStateMap");
        est.expectString("n_state_map");
        int numTiedState = est.getInt("numTiedState");
        est.expectString("n_tied_state");
        int numContextIndependentTiedState = est.getInt("numContextIndependentTiedState");
        est.expectString("n_tied_ci_state");
        int numTiedTransitionMatrices = est.getInt("numTiedTransitionMatrices");
        est.expectString("n_tied_tmat");
        int numStatePerHMM = numStateMap / (numTri + numBase);
        assert (numTiedState == this.mixtureWeightsPool.getFeature(Pool.Feature.NUM_SENONES, 0));
        assert (numTiedTransitionMatrices == this.transitionsPool.size());
        for (int i = 0; i < numBase; ++i) {
            String name = est.getString();
            String left = est.getString();
            String right = est.getString();
            String position = est.getString();
            String attribute = est.getString();
            int tmat = est.getInt("tmat");
            int[] stid = new int[numStatePerHMM - 1];
            for (int j = 0; j < numStatePerHMM - 1; ++j) {
                stid[j] = est.getInt("j");
                assert (stid[j] >= 0 && stid[j] < numContextIndependentTiedState);
            }
            est.expectString("N");
            assert (left.equals("-"));
            assert (right.equals("-"));
            assert (position.equals("-"));
            assert (tmat < numTiedTransitionMatrices);
            Unit unit = this.unitManager.getUnit(name, attribute.equals(FILLER));
            this.contextIndependentUnits.put(unit.getName(), unit);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit);
            }
            if (unit.isFiller() && unit.getName().equals(SILENCE_CIPHONE)) {
                unit = UnitManager.SILENCE;
            }
            float[][] transitionMatrix = this.transitionsPool.get(tmat);
            SenoneSequence ss = this.getSenoneSequence(stid);
            SenoneHMM hmm = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup(position));
            this.hmmManager.put(hmm);
        }
        if (this.hmmManager.get(HMMPosition.UNDEFINED, UnitManager.SILENCE) == null) {
            throw new IOException("Could not find SIL unit in acoustic model");
        }
        String lastUnitName = "";
        Unit lastUnit = null;
        int[] lastStid = null;
        SenoneSequence lastSenoneSequence = null;
        for (int i = 0; i < numTri; ++i) {
            Unit unit;
            String name = est.getString();
            String left = est.getString();
            String right = est.getString();
            String position = est.getString();
            String attribute = est.getString();
            int tmat = est.getInt("tmat");
            int[] stid = new int[numStatePerHMM - 1];
            for (int j = 0; j < numStatePerHMM - 1; ++j) {
                stid[j] = est.getInt("j");
                assert (stid[j] >= numContextIndependentTiedState && stid[j] < numTiedState);
            }
            est.expectString("N");
            assert (!left.equals("-"));
            assert (!right.equals("-"));
            assert (!position.equals("-"));
            assert (attribute.equals("n/a"));
            assert (tmat < numTiedTransitionMatrices);
            if (!useCDUnits) continue;
            String unitName = name + ' ' + left + ' ' + right;
            if (unitName.equals(lastUnitName)) {
                unit = lastUnit;
            } else {
                Unit[] leftContext = new Unit[]{this.contextIndependentUnits.get(left)};
                Unit[] rightContext = new Unit[]{this.contextIndependentUnits.get(right)};
                LeftRightContext context = LeftRightContext.get(leftContext, rightContext);
                unit = this.unitManager.getUnit(name, false, context);
            }
            lastUnitName = unitName;
            lastUnit = unit;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Loaded " + unit);
            }
            float[][] transitionMatrix = this.transitionsPool.get(tmat);
            SenoneSequence ss = lastSenoneSequence;
            if (ss == null || !this.sameSenoneSequence(stid, lastStid)) {
                ss = this.getSenoneSequence(stid);
            }
            lastSenoneSequence = ss;
            lastStid = stid;
            SenoneHMM hmm = new SenoneHMM(unit, ss, transitionMatrix, HMMPosition.lookup(position));
            this.hmmManager.put(hmm);
        }
        est.close();
    }

    protected boolean sameSenoneSequence(int[] ssid1, int[] ssid2) {
        if (ssid1.length == ssid2.length) {
            for (int i = 0; i < ssid1.length; ++i) {
                if (ssid1[i] == ssid2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected SenoneSequence getSenoneSequence(int[] stateid) {
        Senone[] senones = new Senone[stateid.length];
        for (int i = 0; i < stateid.length; ++i) {
            senones[i] = this.senonePool.get(stateid[i]);
        }
        return new SenoneSequence(senones);
    }

    protected Pool<float[]> loadMixtureWeights(String path, float floor) throws IOException, URISyntaxException {
        this.logger.fine("Loading mixture weights from: " + path);
        Properties props = new Properties();
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        Pool<float[]> pool = new Pool<float[]>(path);
        int numStates = this.readInt(dis);
        int numStreams = this.readInt(dis);
        int numGaussiansPerState = this.readInt(dis);
        int numValues = this.readInt(dis);
        this.logger.fine("Number of states " + numStates);
        this.logger.fine("Number of streams " + numStreams);
        this.logger.fine("Number of gaussians per state " + numGaussiansPerState);
        assert (numValues == numStates * numStreams * numGaussiansPerState);
        pool.setFeature(Pool.Feature.NUM_SENONES, numStates);
        pool.setFeature(Pool.Feature.NUM_STREAMS, numStreams);
        pool.setFeature(Pool.Feature.NUM_GAUSSIANS_PER_STATE, numGaussiansPerState);
        if (numStreams != 1) {
            for (int i = 0; i < numStates; ++i) {
                float[] logMixtureWeight = new float[numGaussiansPerState * numStreams];
                for (int j = 0; j < numStreams; ++j) {
                    float[] logStreamMixtureWeight = this.readFloatArray(dis, numGaussiansPerState);
                    Utilities.normalize(logStreamMixtureWeight);
                    Utilities.floorData(logStreamMixtureWeight, floor);
                    this.logMath.linearToLog(logStreamMixtureWeight);
                    System.arraycopy(logStreamMixtureWeight, 0, logMixtureWeight, numGaussiansPerState * j, numGaussiansPerState);
                }
                pool.put(i, logMixtureWeight);
            }
        } else {
            for (int i = 0; i < numStates; ++i) {
                float[] logMixtureWeight = this.readFloatArray(dis, numGaussiansPerState);
                Utilities.normalize(logMixtureWeight);
                Utilities.floorData(logMixtureWeight, floor);
                this.logMath.linearToLog(logMixtureWeight);
                pool.put(i, logMixtureWeight);
            }
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return pool;
    }

    protected Pool<float[][]> loadTransitionMatrices(String path) throws IOException, URISyntaxException {
        this.logger.fine("Loading transition matrices from: " + path);
        Properties props = new Properties();
        DataInputStream dis = this.readS3BinaryHeader(path, props);
        String version = props.getProperty("version");
        if (version == null || !version.equals("1.0")) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        Pool<float[][]> pool = new Pool<float[][]>(path);
        int numMatrices = this.readInt(dis);
        int numRows = this.readInt(dis);
        int numStates = this.readInt(dis);
        int numValues = this.readInt(dis);
        assert (numValues == numStates * numRows * numMatrices);
        for (int i = 0; i < numMatrices; ++i) {
            float[][] tmat = new float[numStates][];
            tmat[numStates - 1] = new float[numStates];
            this.logMath.linearToLog(tmat[numStates - 1]);
            for (int j = 0; j < numRows; ++j) {
                tmat[j] = this.readFloatArray(dis, numStates);
                Utilities.nonZeroFloor(tmat[j], 0.0f);
                Utilities.normalize(tmat[j]);
                this.logMath.linearToLog(tmat[j]);
            }
            pool.put(i, tmat);
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return pool;
    }

    protected float[][] loadTransformMatrix(String path) throws IOException {
        DataInputStream dis;
        this.logger.fine("Loading transform matrix from: " + path);
        Properties props = new Properties();
        try {
            dis = this.readS3BinaryHeader(path, props);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return null;
        }
        String version = props.getProperty("version");
        if (version == null || !version.equals(TRANSFORM_FILE_VERSION)) {
            throw new IOException("Unsupported version in " + path);
        }
        String checksum = props.getProperty("chksum0");
        boolean doCheckSum = checksum != null && checksum.equals("yes");
        this.resetChecksum();
        this.readInt(dis);
        int numRows = this.readInt(dis);
        int numValues = this.readInt(dis);
        int num = this.readInt(dis);
        assert (num == numRows * numValues);
        float[][] result = new float[numRows][];
        for (int i = 0; i < numRows; ++i) {
            result[i] = this.readFloatArray(dis, numValues);
        }
        this.validateChecksum(dis, doCheckSum);
        dis.close();
        return result;
    }

    @Override
    public Pool<float[]> getMeansPool() {
        return this.meansPool;
    }

    @Override
    public Pool<float[][]> getMeansTransformationMatrixPool() {
        return this.meanTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getMeansTransformationVectorPool() {
        return this.meanTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getVariancePool() {
        return this.variancePool;
    }

    @Override
    public Pool<float[][]> getVarianceTransformationMatrixPool() {
        return this.varianceTransformationMatrixPool;
    }

    @Override
    public Pool<float[]> getVarianceTransformationVectorPool() {
        return this.varianceTransformationVectorPool;
    }

    @Override
    public Pool<float[]> getMixtureWeightPool() {
        return this.mixtureWeightsPool;
    }

    @Override
    public Pool<float[][]> getTransitionMatrixPool() {
        return this.transitionsPool;
    }

    @Override
    public float[][] getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public Pool<Senone> getSenonePool() {
        return this.senonePool;
    }

    @Override
    public int getLeftContextSize() {
        return 1;
    }

    @Override
    public int getRightContextSize() {
        return 1;
    }

    @Override
    public HMMManager getHMMManager() {
        return this.hmmManager;
    }

    @Override
    public void logInfo() {
        this.logger.info("Sphinx3Loader");
        this.meansPool.logInfo(this.logger);
        this.variancePool.logInfo(this.logger);
        this.transitionsPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        if (this.meanTransformationMatrixPool != null) {
            this.meanTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.meanTransformationVectorPool != null) {
            this.meanTransformationVectorPool.logInfo(this.logger);
        }
        if (this.varianceTransformationMatrixPool != null) {
            this.varianceTransformationMatrixPool.logInfo(this.logger);
        }
        if (this.varianceTransformationVectorPool != null) {
            this.varianceTransformationVectorPool.logInfo(this.logger);
        }
        this.mixtureWeightsPool.logInfo(this.logger);
        this.senonePool.logInfo(this.logger);
        this.logger.info("Context Independent Unit Entries: " + this.contextIndependentUnits.size());
        this.hmmManager.logInfo(this.logger);
    }
}

