/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic.tiedstate;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.MixtureComponent;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.ScoreCachingSenone;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.Senone;
import edu.cmu.sphinx.util.LogMath;

public class GaussianMixture
extends ScoreCachingSenone {
    private float[] logMixtureWeights;
    private MixtureComponent[] mixtureComponents;
    private long id;
    private LogMath logMath;

    public GaussianMixture(LogMath logMath, float[] logMixtureWeights, MixtureComponent[] mixtureComponents, long id) {
        assert (mixtureComponents.length == logMixtureWeights.length);
        this.logMath = logMath;
        this.mixtureComponents = mixtureComponents;
        this.logMixtureWeights = logMixtureWeights;
        this.id = id;
    }

    @Override
    public void dump(String msg) {
        System.out.println(msg + " GaussianMixture: ID " + this.getID());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Senone)) {
            return false;
        }
        Senone other = (Senone)o;
        return this.getID() == other.getID();
    }

    public int hashCode() {
        long id = this.getID();
        int high = (int)(id >> 32);
        int low = (int)id;
        return high + low;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public String toString() {
        return "senone id: " + this.getID();
    }

    @Override
    public float calculateScore(Data feature) {
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] featureVector = FloatData.toFloatData(feature).getValues();
        float logTotal = LogMath.getLogZero();
        for (int i = 0; i < this.mixtureComponents.length; ++i) {
            logTotal = this.logMath.addAsLinear(logTotal, this.mixtureComponents[i].getScore(featureVector) + this.logMixtureWeights[i]);
        }
        return logTotal;
    }

    @Override
    public float[] calculateComponentScore(Data feature) {
        if (feature instanceof DoubleData) {
            System.err.println("DoubleData conversion required on mixture level!");
        }
        float[] featureVector = FloatData.toFloatData(feature).getValues();
        float[] logComponentScore = new float[this.mixtureComponents.length];
        for (int i = 0; i < this.mixtureComponents.length; ++i) {
            logComponentScore[i] = this.mixtureComponents[i].getScore(featureVector) + this.logMixtureWeights[i];
        }
        return logComponentScore;
    }

    public MixtureComponent[] getMixtureComponents() {
        return this.mixtureComponents;
    }

    public int dimension() {
        return this.mixtureComponents[0].getMean().length;
    }

    public int numComponents() {
        return this.mixtureComponents.length;
    }

    public float[] getComponentWeights() {
        float[] mixWeights = new float[this.getMixtureComponents().length];
        for (int i = 0; i < mixWeights.length; ++i) {
            mixWeights[i] = (float)this.logMath.logToLinear(this.logMixtureWeights[i]);
        }
        return mixWeights;
    }

    public LogMath getLogMath() {
        return this.logMath;
    }

    public float getLogComponentWeight(int index) {
        return this.logMixtureWeights[index];
    }
}

