/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.acoustic;

import edu.cmu.sphinx.linguist.acoustic.Context;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnitManager
implements Configurable {
    public static final String SILENCE_NAME = "SIL";
    private static final int SILENCE_ID = 1;
    public static final Unit SILENCE = new Unit("SIL", true, 1);
    private final Map<String, Unit> ciMap = new HashMap<String, Unit>();
    private int nextID;
    private Logger logger;

    public UnitManager() {
        this.ciMap.put(SILENCE_NAME, SILENCE);
        this.nextID = 2;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
    }

    public Unit getUnit(String name, boolean filler, Context context) {
        Unit unit = this.ciMap.get(name);
        if (context == Context.EMPTY_CONTEXT) {
            if (unit == null) {
                unit = new Unit(name, filler, this.nextID++);
                this.ciMap.put(name, unit);
                if (this.logger != null && this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("CI Unit: " + unit);
                }
            }
        } else {
            unit = new Unit(unit, filler, context);
        }
        return unit;
    }

    public Unit getUnit(String name, boolean filler) {
        return this.getUnit(name, filler, Context.EMPTY_CONTEXT);
    }

    public Unit getUnit(String name) {
        return this.getUnit(name, false, Context.EMPTY_CONTEXT);
    }
}

