/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JSGFRuleGrammarManager {
    protected Map<String, JSGFRuleGrammar> grammars;
    protected boolean caseSensitiveNames = true;

    JSGFRuleGrammarManager(boolean caseSensitiveNames) {
        this.caseSensitiveNames = caseSensitiveNames;
        this.grammars = new HashMap<String, JSGFRuleGrammar>();
    }

    public JSGFRuleGrammarManager() {
        this.grammars = new HashMap<String, JSGFRuleGrammar>();
    }

    public Collection<JSGFRuleGrammar> grammars() {
        return this.grammars.values();
    }

    public void remove(JSGFRuleGrammar grammar) {
        String name = grammar.getName();
        this.grammars.remove(name);
    }

    public void remove(String name) {
        this.grammars.remove(name);
    }

    protected void storeGrammar(JSGFRuleGrammar grammar) {
        if (this.caseSensitiveNames) {
            this.grammars.put(grammar.getName(), grammar);
        } else {
            this.grammars.put(grammar.getName().toLowerCase(), grammar);
        }
    }

    public JSGFRuleGrammar retrieveGrammar(String name) {
        return this.grammars.get(this.caseSensitiveNames ? name : name.toLowerCase());
    }

    public void linkGrammars() throws JSGFGrammarException {
        for (JSGFRuleGrammar grammar : this.grammars.values()) {
            grammar.resolveAllRules();
        }
    }
}

