/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.jsgf;

import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammarManager;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class JSGFRuleGrammar {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Map<String, JSGFRuleState> rules = new HashMap<String, JSGFRuleState>();
    protected final List<JSGFRuleName> imports = new ArrayList<JSGFRuleName>();
    protected final List<String> importedRules = new ArrayList<String>();
    protected final Map<String, Collection<String>> ruleTags = new HashMap<String, Collection<String>>();
    private String name;
    private JSGFRuleGrammarManager manager;
    Properties ruleDocComments = new Properties();
    Properties importDocComments = new Properties();
    String grammarDocComment;

    public JSGFRuleGrammar(String name, JSGFRuleGrammarManager manager) {
        this.name = name;
        this.manager = manager;
    }

    public void addGrammarDocComment(String comment) {
        this.grammarDocComment = comment;
    }

    public void addImport(JSGFRuleName importName) {
        if (!this.imports.contains(importName)) {
            this.imports.add(importName);
        }
    }

    public void addImportDocComment(JSGFRuleName imp, String comment) {
        this.importDocComments.put(imp.toString(), comment);
    }

    public void addRuleDocComment(String rname, String comment) {
        this.ruleDocComments.put(rname, comment);
    }

    public void addSampleSentence(String ruleName, String sample) {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state == null) {
            return;
        }
        state.samples.add(sample);
    }

    public void deleteRule(String ruleName) throws IllegalArgumentException {
        this.rules.remove(this.getKnownRule((String)ruleName).ruleName);
    }

    public String getGrammarDocComment() {
        return this.grammarDocComment;
    }

    public String getImportDocComment(JSGFRuleName imp) {
        return this.importDocComments.getProperty(imp.toString(), null);
    }

    public Collection<String> getJSGFTags(String ruleName) {
        return this.ruleTags.get(ruleName);
    }

    private JSGFRule getKnownRule(String ruleName) {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state == null) {
            throw new IllegalArgumentException("Unknown Rule: " + ruleName);
        }
        return state.rule;
    }

    public String getName() {
        return this.name;
    }

    public JSGFRule getRule(String ruleName) {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state == null) {
            return null;
        }
        return state.rule;
    }

    public String getRuleDocComment(String rname) {
        return this.ruleDocComments.getProperty(rname, null);
    }

    public boolean isRulePublic(String ruleName) throws IllegalArgumentException {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state == null) {
            return false;
        }
        return state.isPublic;
    }

    public List<JSGFRuleName> getImports() {
        return this.imports;
    }

    public Set<String> getRuleNames() {
        return this.rules.keySet();
    }

    public void removeImport(JSGFRuleName importName) throws IllegalArgumentException {
        if (this.imports.contains(importName)) {
            this.imports.remove(importName);
        }
    }

    public JSGFRuleName resolve(JSGFRuleName ruleName) throws JSGFGrammarException {
        JSGFRuleGrammar g;
        JSGFRuleName rn = new JSGFRuleName(ruleName.getRuleName());
        String simpleName = rn.getSimpleRuleName();
        String grammarName = rn.getSimpleGrammarName();
        String packageName = rn.getPackageName();
        String fullGrammarName = rn.getFullGrammarName();
        if (packageName != null && grammarName == null) {
            throw new JSGFGrammarException("Error: badly formed rulename " + rn);
        }
        if (ruleName.getSimpleRuleName().equals("NULL")) {
            return JSGFRuleName.NULL;
        }
        if (ruleName.getSimpleRuleName().equals("VOID")) {
            return JSGFRuleName.VOID;
        }
        if (fullGrammarName == null && this.getRule(simpleName) != null) {
            return new JSGFRuleName(this.name + '.' + simpleName);
        }
        if (fullGrammarName != null && (g = this.manager.retrieveGrammar(fullGrammarName)) != null && g.getRule(simpleName) != null) {
            return new JSGFRuleName(fullGrammarName + '.' + simpleName);
        }
        ArrayList<JSGFRuleName> matches = new ArrayList<JSGFRuleName>();
        ArrayList<JSGFRuleName> imports = new ArrayList<JSGFRuleName>(this.imports);
        imports.add(new JSGFRuleName(this.name + ".*"));
        for (JSGFRuleName importName : imports) {
            String importSimpleName = importName.getSimpleRuleName();
            String importGrammarName = importName.getSimpleGrammarName();
            String importFullGrammarName = importName.getFullGrammarName();
            if (importFullGrammarName == null) {
                throw new JSGFGrammarException("Error: badly formed import " + ruleName);
            }
            JSGFRuleGrammar gref = this.manager.retrieveGrammar(importFullGrammarName);
            if (gref == null) {
                System.out.println("Warning: import of unknown grammar " + ruleName + " in " + this.name);
                continue;
            }
            if (!importSimpleName.equals("*") && gref.getRule(importSimpleName) == null) {
                System.out.println("Warning: import of undefined rule " + ruleName + " in " + this.name);
                continue;
            }
            if (importFullGrammarName.equals(fullGrammarName) || importGrammarName.equals(fullGrammarName)) {
                if (importSimpleName.equals("*")) {
                    if (gref.getRule(simpleName) == null) continue;
                    matches.add(new JSGFRuleName(importFullGrammarName + '.' + simpleName));
                    continue;
                }
                if (!importSimpleName.equals(simpleName)) continue;
                matches.add(new JSGFRuleName(importFullGrammarName + '.' + simpleName));
                continue;
            }
            if (fullGrammarName != null) continue;
            if (importSimpleName.equals("*")) {
                if (gref.getRule(simpleName) == null) continue;
                matches.add(new JSGFRuleName(importFullGrammarName + '.' + simpleName));
                continue;
            }
            if (!importSimpleName.equals(simpleName)) continue;
            matches.add(new JSGFRuleName(importFullGrammarName + '.' + simpleName));
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (JSGFRuleName)matches.get(0);
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("Warning: ambiguous reference ").append(rn).append(" in ").append(this.name).append(" to ");
        for (JSGFRuleName tmp : matches) {
            b.append(tmp).append(" and ");
        }
        b.setLength(b.length() - 5);
        throw new JSGFGrammarException(b.toString());
    }

    public void resolveAllRules() throws JSGFGrammarException {
        StringBuilder b = new StringBuilder();
        for (JSGFRuleName ruleName : this.imports) {
            String grammarName = ruleName.getFullGrammarName();
            JSGFRuleGrammar GI = this.manager.retrieveGrammar(grammarName);
            if (GI != null) continue;
            b.append("Undefined grammar ").append(grammarName).append(" imported in ").append(this.name).append('\n');
        }
        if (b.length() > 0) {
            throw new JSGFGrammarException(b.toString());
        }
        for (JSGFRuleState state : this.rules.values()) {
            this.resolveRule(state.rule);
        }
    }

    protected void resolveRule(JSGFRule r) throws JSGFGrammarException {
        if (r instanceof JSGFRuleToken) {
            return;
        }
        if (r instanceof JSGFRuleAlternatives) {
            for (JSGFRule rule : ((JSGFRuleAlternatives)r).getRules()) {
                this.resolveRule(rule);
            }
            return;
        }
        if (r instanceof JSGFRuleSequence) {
            for (JSGFRule rule : ((JSGFRuleSequence)r).getRules()) {
                this.resolveRule(rule);
            }
            return;
        }
        if (r instanceof JSGFRuleCount) {
            this.resolveRule(((JSGFRuleCount)r).getRule());
            return;
        }
        if (r instanceof JSGFRuleTag) {
            JSGFRuleTag rt = (JSGFRuleTag)r;
            JSGFRule rule = rt.getRule();
            String ruleStr = rule.toString();
            Collection<String> tags = this.ruleTags.get(ruleStr);
            if (tags == null) {
                tags = new HashSet<String>();
                this.ruleTags.put(ruleStr, tags);
            }
            tags.add(rt.getTag());
            this.resolveRule(rule);
            return;
        }
        if (r instanceof JSGFRuleName) {
            JSGFRuleName rn = (JSGFRuleName)r;
            JSGFRuleName resolved = this.resolve(rn);
            if (resolved == null) {
                throw new JSGFGrammarException("Unresolvable rulename in grammar " + this.name + ": " + rn);
            }
            rn.resolvedRuleName = resolved.getRuleName();
            rn.setRuleName(resolved.getRuleName());
            return;
        }
        throw new JSGFGrammarException("Unknown rule type");
    }

    public void setEnabled(boolean enabled) {
        for (JSGFRuleState state : this.rules.values()) {
            state.isEnabled = enabled;
        }
    }

    public boolean isEnabled(String ruleName) {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state != null) {
            return state.isEnabled;
        }
        return false;
    }

    public void setEnabled(String ruleName, boolean enabled) throws IllegalArgumentException {
        JSGFRuleState state = this.rules.get(ruleName);
        if (state.isEnabled != enabled) {
            state.isEnabled = enabled;
        }
    }

    public void setRule(String ruleName, JSGFRule rule, boolean isPublic) throws NullPointerException, IllegalArgumentException {
        JSGFRuleState state = new JSGFRuleState(rule, true, isPublic);
        this.rules.put(ruleName, state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#JSGF V1.0;").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        sb.append(this.formatComment(this.grammarDocComment));
        sb.append(LINE_SEPARATOR);
        sb.append("grammar ").append(this.name).append(';').append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        Set<Object> docComments = this.importDocComments.keySet();
        for (int i = 0; i < this.imports.size(); ++i) {
            String curImport = '<' + this.imports.get(i).getRuleName() + '>';
            if (!docComments.contains(curImport)) continue;
            sb.append(this.formatComment((String)this.importDocComments.get(curImport)));
            sb.append(LINE_SEPARATOR);
            sb.append("import ").append(curImport + ';').append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
        }
        docComments = this.ruleDocComments.keySet();
        for (Map.Entry<String, JSGFRuleState> entry : this.rules.entrySet()) {
            String rule = entry.getKey();
            if (docComments.size() > 0 && docComments.contains(rule)) {
                sb.append(this.formatComment((String)this.ruleDocComments.get(rule))).append(LINE_SEPARATOR);
            }
            JSGFRuleState state = entry.getValue();
            if (state.isPublic) {
                sb.append("public ");
            }
            sb.append('<').append((Object)rule).append("> = ").append(state.rule).append(';').append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String formatComment(String comment) {
        StringBuilder sb = new StringBuilder("");
        if (comment == null) {
            return sb.toString();
        }
        if (Pattern.compile("[\\n\\r\\f]+").matcher(comment).find()) {
            String[] tokens = comment.split('[' + LINE_SEPARATOR + "]+");
            sb.append("/**").append(LINE_SEPARATOR);
            sb.append("  *").append(tokens[0]).append(LINE_SEPARATOR);
            for (int i = 1; i < tokens.length; ++i) {
                sb.append("  *").append(tokens[i]).append(LINE_SEPARATOR);
            }
            sb.append("  */");
            return sb.toString();
        }
        return "//" + comment;
    }

    public void saveJSGF(URL url) throws URISyntaxException, IOException {
        PrintStream out = new PrintStream(new File(url.toURI()));
        out.print(this.toString());
        out.flush();
        out.close();
    }

    public boolean isRuleChanged(String ruleName) {
        JSGFRuleState state = this.rules.get(ruleName);
        return state.isChanged;
    }

    public void setRuleChanged(String ruleName, boolean changed) {
        JSGFRuleState state = this.rules.get(ruleName);
        state.isChanged = changed;
    }

    class JSGFRuleState {
        public boolean isPublic;
        public boolean isEnabled;
        public JSGFRule rule;
        public ArrayList<String> samples;
        public boolean isChanged;

        public JSGFRuleState(JSGFRule rule, boolean isEnabled, boolean isPublic) {
            this.rule = rule;
            this.isPublic = isPublic;
            this.isEnabled = isEnabled;
            this.samples = new ArrayList();
        }
    }
}

