/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.util.DataUtil;
import edu.cmu.sphinx.frontend.util.Utterance;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class Microphone
extends BaseDataProcessor {
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    @S4Boolean(defaultValue=true)
    public static final String PROP_CLOSE_BETWEEN_UTTERANCES = "closeBetweenUtterances";
    @S4Integer(defaultValue=10)
    public static final String PROP_MSEC_PER_READ = "msecPerRead";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Integer(defaultValue=1)
    public static final String PROP_CHANNELS = "channels";
    @S4Boolean(defaultValue=true)
    public static final String PROP_BIG_ENDIAN = "bigEndian";
    @S4Boolean(defaultValue=true)
    public static final String PROP_SIGNED = "signed";
    @S4Boolean(defaultValue=false)
    public static final String PROP_KEEP_LAST_AUDIO = "keepLastAudio";
    @S4String(defaultValue="average", range={"average", "selectChannel"})
    public static final String PROP_STEREO_TO_MONO = "stereoToMono";
    @S4Integer(defaultValue=0)
    public static final String PROP_SELECT_CHANNEL = "selectChannel";
    @S4String(defaultValue="default")
    public static final String PROP_SELECT_MIXER = "selectMixer";
    @S4Integer(defaultValue=6400)
    public static final String PROP_BUFFER_SIZE = "bufferSize";
    private AudioFormat finalFormat;
    private AudioInputStream audioStream;
    private TargetDataLine audioLine;
    private BlockingQueue<Data> audioList;
    private Utterance currentUtterance;
    private boolean doConversion;
    private volatile boolean recording;
    private volatile boolean utteranceEndReached = true;
    private RecordingThread recorder;
    private AudioFormat desiredFormat;
    private boolean closeBetweenUtterances;
    private boolean keepDataReference;
    private boolean signed;
    private boolean bigEndian;
    private int frameSizeInBytes;
    private int msecPerRead;
    private int selectedChannel;
    private String selectedMixerIndex;
    private String stereoToMono;
    private int sampleRate;
    private int audioBufferSize;

    public Microphone(int sampleRate, int bitsPerSample, int channels, boolean bigEndian, boolean signed, boolean closeBetweenUtterances, int msecPerRead, boolean keepLastAudio, String stereoToMono, int selectedChannel, String selectedMixerIndex, int audioBufferSize) {
        this.initLogger();
        this.sampleRate = sampleRate;
        this.bigEndian = bigEndian;
        this.signed = signed;
        this.desiredFormat = new AudioFormat(sampleRate, bitsPerSample, channels, signed, bigEndian);
        this.closeBetweenUtterances = closeBetweenUtterances;
        this.msecPerRead = msecPerRead;
        this.keepDataReference = keepLastAudio;
        this.stereoToMono = stereoToMono;
        this.selectedChannel = selectedChannel;
        this.selectedMixerIndex = selectedMixerIndex;
        this.audioBufferSize = audioBufferSize;
    }

    public Microphone() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logger = ps.getLogger();
        this.sampleRate = ps.getInt(PROP_SAMPLE_RATE);
        int sampleSizeInBits = ps.getInt(PROP_BITS_PER_SAMPLE);
        int channels = ps.getInt(PROP_CHANNELS);
        this.bigEndian = ps.getBoolean(PROP_BIG_ENDIAN);
        this.signed = ps.getBoolean(PROP_SIGNED);
        this.desiredFormat = new AudioFormat(this.sampleRate, sampleSizeInBits, channels, this.signed, this.bigEndian);
        this.closeBetweenUtterances = ps.getBoolean(PROP_CLOSE_BETWEEN_UTTERANCES);
        this.msecPerRead = ps.getInt(PROP_MSEC_PER_READ);
        this.keepDataReference = ps.getBoolean(PROP_KEEP_LAST_AUDIO);
        this.stereoToMono = ps.getString(PROP_STEREO_TO_MONO);
        this.selectedChannel = ps.getInt(PROP_SELECT_CHANNEL);
        this.selectedMixerIndex = ps.getString(PROP_SELECT_MIXER);
        this.audioBufferSize = ps.getInt(PROP_BUFFER_SIZE);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.audioList = new LinkedBlockingQueue<Data>();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.desiredFormat);
        if (!AudioSystem.isLineSupported(info)) {
            this.logger.info(this.desiredFormat + " not supported");
            AudioFormat nativeFormat = DataUtil.getNativeAudioFormat(this.desiredFormat, this.getSelectedMixer());
            if (nativeFormat == null) {
                this.logger.severe("couldn't find suitable target audio format");
            } else {
                this.finalFormat = nativeFormat;
                this.doConversion = AudioSystem.isConversionSupported(this.desiredFormat, nativeFormat);
                if (this.doConversion) {
                    this.logger.info("Converting from " + this.finalFormat.getSampleRate() + "Hz to " + this.desiredFormat.getSampleRate() + "Hz");
                } else {
                    this.logger.info("Using native format: Cannot convert from " + this.finalFormat.getSampleRate() + "Hz to " + this.desiredFormat.getSampleRate() + "Hz");
                }
            }
        } else {
            this.logger.info("Desired format: " + this.desiredFormat + " supported.");
            this.finalFormat = this.desiredFormat;
        }
    }

    private Mixer getSelectedMixer() {
        if (this.selectedMixerIndex.equals("default")) {
            return null;
        }
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        if (this.selectedMixerIndex.equals("last")) {
            return AudioSystem.getMixer(mixerInfo[mixerInfo.length - 1]);
        }
        int index = Integer.parseInt(this.selectedMixerIndex);
        return AudioSystem.getMixer(mixerInfo[index]);
    }

    private TargetDataLine getAudioLine() {
        if (this.audioLine != null) {
            return this.audioLine;
        }
        try {
            this.logger.info("Final format: " + this.finalFormat);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.finalFormat);
            Mixer selectedMixer = this.getSelectedMixer();
            this.audioLine = selectedMixer == null ? (TargetDataLine)AudioSystem.getLine(info) : (TargetDataLine)selectedMixer.getLine(info);
            this.audioLine.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    Microphone.this.logger.info("line listener " + event);
                }
            });
        }
        catch (LineUnavailableException e) {
            this.logger.severe("microphone unavailable " + e.getMessage());
        }
        return this.audioLine;
    }

    private boolean open() {
        TargetDataLine audioLine = this.getAudioLine();
        if (audioLine != null) {
            if (!audioLine.isOpen()) {
                this.logger.info("open");
                try {
                    audioLine.open(this.finalFormat, this.audioBufferSize);
                }
                catch (LineUnavailableException e) {
                    this.logger.severe("Can't open microphone " + e.getMessage());
                    return false;
                }
                this.audioStream = new AudioInputStream(audioLine);
                if (this.doConversion) {
                    this.audioStream = AudioSystem.getAudioInputStream(this.desiredFormat, this.audioStream);
                    assert (this.audioStream != null);
                }
                float sec = (float)this.msecPerRead / 1000.0f;
                this.frameSizeInBytes = this.audioStream.getFormat().getSampleSizeInBits() / 8 * (int)(sec * this.audioStream.getFormat().getSampleRate());
                this.logger.info("Frame size: " + this.frameSizeInBytes + " bytes");
            }
            return true;
        }
        this.logger.severe("Can't find microphone");
        return false;
    }

    public AudioFormat getAudioFormat() {
        return this.finalFormat;
    }

    public Utterance getUtterance() {
        return this.currentUtterance;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public synchronized boolean startRecording() {
        if (this.recording) {
            return false;
        }
        if (!this.open()) {
            return false;
        }
        this.utteranceEndReached = false;
        if (this.audioLine.isRunning()) {
            this.logger.severe("Whoops: audio line is running");
        }
        assert (this.recorder == null);
        this.recorder = new RecordingThread("Microphone");
        this.recorder.start();
        this.recording = true;
        return true;
    }

    public synchronized void stopRecording() {
        if (this.audioLine != null) {
            if (this.recorder != null) {
                this.recorder.stopRecording();
                this.recorder = null;
            }
            this.recording = false;
        }
    }

    private double[] convertStereoToMono(double[] samples, int channels) {
        assert (samples.length % channels == 0);
        double[] finalSamples = new double[samples.length / channels];
        if (this.stereoToMono.equals("average")) {
            int i = 0;
            int j = 0;
            while (i < samples.length) {
                double sum = samples[i++];
                for (int c = 1; c < channels; ++c) {
                    sum += samples[i++];
                }
                finalSamples[j] = sum / (double)channels;
                ++j;
            }
        } else if (this.stereoToMono.equals(PROP_SELECT_CHANNEL)) {
            int i = this.selectedChannel;
            int j = 0;
            while (i < samples.length) {
                finalSamples[j] = samples[i];
                i += channels;
                ++j;
            }
        } else {
            throw new Error("Unsupported stereo to mono conversion: " + this.stereoToMono);
        }
        return finalSamples;
    }

    public void clear() {
        this.audioList.clear();
    }

    @Override
    public Data getData() throws DataProcessingException {
        this.getTimer().start();
        Data output = null;
        if (!this.utteranceEndReached) {
            try {
                output = this.audioList.take();
            }
            catch (InterruptedException ie) {
                throw new DataProcessingException("cannot take Data from audioList", ie);
            }
            if (output instanceof DataEndSignal) {
                this.utteranceEndReached = true;
            }
        }
        this.getTimer().stop();
        return output;
    }

    public boolean hasMoreData() {
        return !this.utteranceEndReached || !this.audioList.isEmpty();
    }

    class RecordingThread
    extends Thread {
        private boolean done;
        private volatile boolean started;
        private long totalSamplesRead;
        private final Object lock;

        public RecordingThread(String name) {
            super(name);
            this.lock = new Object();
        }

        @Override
        public void start() {
            this.started = false;
            super.start();
            this.waitForStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRecording() {
            Microphone.this.audioLine.stop();
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.done) {
                        this.lock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.totalSamplesRead = 0L;
            Microphone.this.logger.info("started recording");
            if (Microphone.this.keepDataReference) {
                Microphone.this.currentUtterance = new Utterance("Microphone", Microphone.this.audioStream.getFormat());
            }
            Microphone.this.audioList.add(new DataStartSignal(Microphone.this.sampleRate));
            Microphone.this.logger.info("DataStartSignal added");
            try {
                Microphone.this.audioLine.start();
                while (!this.done) {
                    Data data = this.readData(Microphone.this.currentUtterance);
                    if (data == null) {
                        this.done = true;
                        break;
                    }
                    Microphone.this.audioList.add(data);
                }
                Microphone.this.audioLine.flush();
                if (Microphone.this.closeBetweenUtterances) {
                    Microphone.this.audioStream.close();
                    Microphone.this.audioLine.close();
                    System.err.println("set to null");
                    Microphone.this.audioLine = null;
                }
            }
            catch (IOException ioe) {
                Microphone.this.logger.warning("IO Exception " + ioe.getMessage());
                ioe.printStackTrace();
            }
            long duration = (long)((double)this.totalSamplesRead / (double)Microphone.this.audioStream.getFormat().getSampleRate() * 1000.0);
            Microphone.this.audioList.add(new DataEndSignal(duration));
            Microphone.this.logger.info("DataEndSignal ended");
            Microphone.this.logger.info("stopped recording");
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        private synchronized void waitForStart() {
            try {
                while (!this.started) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                Microphone.this.logger.warning("wait was interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Data readData(Utterance utterance) throws IOException {
            byte[] data = new byte[Microphone.this.frameSizeInBytes];
            int channels = Microphone.this.audioStream.getFormat().getChannels();
            long collectTime = System.currentTimeMillis();
            long firstSampleNumber = this.totalSamplesRead / (long)channels;
            int numBytesRead = Microphone.this.audioStream.read(data, 0, data.length);
            if (!this.started) {
                RecordingThread recordingThread = this;
                synchronized (recordingThread) {
                    this.started = true;
                    this.notifyAll();
                }
            }
            if (Microphone.this.logger.isLoggable(Level.FINE)) {
                Microphone.this.logger.info("Read " + numBytesRead + " bytes from audio stream.");
            }
            if (numBytesRead <= 0) {
                return null;
            }
            int sampleSizeInBytes = Microphone.this.audioStream.getFormat().getSampleSizeInBits() / 8;
            this.totalSamplesRead += (long)(numBytesRead / sampleSizeInBytes);
            if (numBytesRead != Microphone.this.frameSizeInBytes) {
                if (numBytesRead % sampleSizeInBytes != 0) {
                    throw new Error("Incomplete sample read.");
                }
                data = Arrays.copyOf(data, numBytesRead);
            }
            if (Microphone.this.keepDataReference) {
                utterance.add(data);
            }
            double[] samples = Microphone.this.bigEndian ? DataUtil.bytesToValues(data, 0, data.length, sampleSizeInBytes, Microphone.this.signed) : DataUtil.littleEndianBytesToValues(data, 0, data.length, sampleSizeInBytes, Microphone.this.signed);
            if (channels > 1) {
                samples = Microphone.this.convertStereoToMono(samples, channels);
            }
            return new DoubleData(samples, (int)Microphone.this.audioStream.getFormat().getSampleRate(), collectTime, firstSampleNumber);
        }
    }
}

