/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.util;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4String;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DataDumper
extends BaseDataProcessor {
    @S4Boolean(defaultValue=true)
    public static final String PROP_ENABLE = "enable";
    @S4String(defaultValue="0.00000E00;-0.00000E00")
    public static final String PROP_OUTPUT_FORMAT = "outputFormat";
    @S4Boolean(defaultValue=true)
    public static final String PROP_OUTPUT_SIGNALS = "outputSignals";
    private int frameCount;
    private boolean enable;
    private boolean outputSignals;
    private DecimalFormat formatter;

    public DataDumper(boolean enable, String format, boolean outputSignals) {
        this.initLogger();
        this.formatter = new DecimalFormat(format, new DecimalFormatSymbols(Locale.US));
        this.outputSignals = outputSignals;
        this.enable = enable;
    }

    public DataDumper() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.logger = ps.getLogger();
        this.enable = ps.getBoolean(PROP_ENABLE);
        String format = ps.getString(PROP_OUTPUT_FORMAT);
        this.formatter = new DecimalFormat(format, new DecimalFormatSymbols(Locale.US));
        this.outputSignals = ps.getBoolean(PROP_OUTPUT_SIGNALS);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data input = this.getPredecessor().getData();
        if (this.enable) {
            this.dumpData(input);
        }
        return input;
    }

    private void dumpData(Data input) {
        this.logger.finer("dumping data...");
        if (input instanceof Signal) {
            if (this.outputSignals) {
                System.out.println("Signal: " + input);
                if (input instanceof DataStartSignal) {
                    this.frameCount = 0;
                }
            }
        } else if (input instanceof DoubleData) {
            DoubleData dd = (DoubleData)input;
            double[] values = dd.getValues();
            System.out.print("Frame " + values.length);
            for (double val : values) {
                System.out.print(' ' + this.formatter.format(val));
            }
            System.out.println();
        } else if (input instanceof SpeechClassifiedData) {
            SpeechClassifiedData dd = (SpeechClassifiedData)input;
            double[] values = dd.getValues();
            System.out.print("Frame ");
            if (dd.isSpeech()) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            System.out.print(" " + values.length);
            for (double val : values) {
                System.out.print(' ' + this.formatter.format(val));
            }
            System.out.println();
        } else if (input instanceof FloatData) {
            FloatData fd = (FloatData)input;
            float[] values = fd.getValues();
            System.out.print("Frame " + values.length);
            for (float val : values) {
                System.out.print(' ' + this.formatter.format(val));
            }
            System.out.println();
        }
        ++this.frameCount;
    }
}

