/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.endpoint.AbstractVoiceActivityDetector;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;

public class WienerFilter
extends BaseDataProcessor {
    double[] prevNoise;
    double[] prevSignal;
    double[] prevInput;
    double lambda = 0.99;
    double gamma = 0.98;
    double etaMin = 0.01;
    protected AbstractVoiceActivityDetector classifier;
    @S4Component(type=AbstractVoiceActivityDetector.class)
    public static final String PROP_CLASSIFIER = "classifier";

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.classifier = (AbstractVoiceActivityDetector)ps.getComponent(PROP_CLASSIFIER);
    }

    @Override
    public Data getData() throws DataProcessingException {
        Data inputData = this.getPredecessor().getData();
        if (!(inputData instanceof DoubleData)) {
            this.prevNoise = null;
            this.prevSignal = null;
            this.prevInput = null;
            return inputData;
        }
        DoubleData inputDoubleData = (DoubleData)inputData;
        double[] input = inputDoubleData.getValues();
        int length = input.length;
        if (this.prevNoise == null) {
            this.prevNoise = new double[length];
            this.prevSignal = new double[length];
            this.prevInput = new double[length];
            return inputData;
        }
        double[] smoothedInput = this.smooth(input);
        double[] noise = this.estimateNoise(smoothedInput);
        double[] signal = this.filter(input, smoothedInput, noise);
        System.arraycopy(noise, 0, this.prevNoise, 0, length);
        System.arraycopy(signal, 0, this.prevSignal, 0, length);
        System.arraycopy(input, 0, this.prevInput, 0, length);
        DoubleData outputData = new DoubleData(signal, inputDoubleData.getSampleRate(), inputDoubleData.getCollectTime(), inputDoubleData.getFirstSampleNumber());
        return outputData;
    }

    private double[] filter(double[] input, double[] smoothedInput, double[] noise) {
        int length = input.length;
        double[] signal = new double[length];
        for (int i = 0; i < length; ++i) {
            double max = Math.max(smoothedInput[i] - noise[i], 0.0);
            double s = this.gamma * this.prevSignal[i] + (1.0 - this.gamma) * max;
            double eta = Math.max(s / noise[i], this.etaMin);
            signal[i] = eta / (1.0 + eta) * input[i];
        }
        return signal;
    }

    private double[] estimateNoise(double[] smoothedInput) {
        int length = smoothedInput.length;
        double[] noise = new double[length];
        for (int i = 0; i < length; ++i) {
            noise[i] = this.classifier.isSpeech() ? this.prevNoise[i] : this.lambda * this.prevNoise[i] + (1.0 - this.lambda) * smoothedInput[i];
        }
        return noise;
    }

    private double[] smooth(double[] input) {
        int length = input.length;
        double[] smoothedInput = new double[length];
        for (int i = 1; i < length - 1; ++i) {
            smoothedInput[i] = (input[i] + input[i - 1] + input[i + 1] + this.prevInput[i]) / 4.0;
        }
        smoothedInput[0] = (input[0] + input[1] + this.prevInput[0]) / 3.0;
        smoothedInput[length - 1] = (input[length - 1] + input[length - 2] + this.prevInput[length - 1]) / 3.0;
        return smoothedInput;
    }
}

