/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend.endpoint;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.endpoint.SpeechClassifiedData;
import edu.cmu.sphinx.frontend.endpoint.SpeechEndSignal;
import edu.cmu.sphinx.frontend.endpoint.SpeechStartSignal;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SpeechMarker
extends BaseDataProcessor {
    @S4Integer(defaultValue=200)
    public static final String PROP_START_SPEECH = "startSpeech";
    private int startSpeechTime;
    @S4Integer(defaultValue=500)
    public static final String PROP_END_SILENCE = "endSilence";
    private int endSilenceTime;
    @S4Integer(defaultValue=50)
    public static final String PROP_SPEECH_LEADER = "speechLeader";
    private int speechLeader;
    @S4Integer(defaultValue=30)
    public static final String PROP_SPEECH_LEADER_FRAMES = "speechLeaderFrames";
    private int speechLeaderFrames;
    @S4Integer(defaultValue=50)
    public static final String PROP_SPEECH_TRAILER = "speechTrailer";
    private int speechTrailer;
    @S4Double(defaultValue=15.0)
    public static final String PROP_END_SILENCE_DECAY = "endSilenceDecay";
    private double endSilenceDecay;
    private List<Data> outputQueue;
    private boolean inSpeech;
    private int frameCount;
    private int initialEndSilenceTime;

    public SpeechMarker(int startSpeechTime, int endSilenceTime, int speechLeader, int speechLeaderFrames, int speechTrailer, double endSilenceDecay) {
        this.initLogger();
        this.startSpeechTime = startSpeechTime;
        this.endSilenceTime = endSilenceTime;
        this.speechLeader = speechLeader;
        this.speechLeaderFrames = speechLeaderFrames;
        this.speechTrailer = speechTrailer;
        this.endSilenceDecay = endSilenceDecay;
        this.initialEndSilenceTime = endSilenceTime;
    }

    public SpeechMarker() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.startSpeechTime = ps.getInt(PROP_START_SPEECH);
        this.endSilenceTime = ps.getInt(PROP_END_SILENCE);
        this.speechLeader = ps.getInt(PROP_SPEECH_LEADER);
        this.speechLeaderFrames = ps.getInt(PROP_SPEECH_LEADER_FRAMES);
        this.speechTrailer = ps.getInt(PROP_SPEECH_TRAILER);
        this.endSilenceDecay = ps.getDouble(PROP_END_SILENCE_DECAY);
        this.initialEndSilenceTime = this.endSilenceTime;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reset();
    }

    private void reset() {
        this.inSpeech = false;
        this.frameCount = 0;
        this.outputQueue = new ArrayList<Data>();
    }

    @Override
    public Data getData() throws DataProcessingException {
        SpeechClassifiedData data;
        Data audio;
        while (this.outputQueue.size() < this.speechLeaderFrames && (audio = this.readData()) != null) {
            if (!this.inSpeech) {
                if (audio instanceof SpeechClassifiedData) {
                    boolean speechStarted;
                    data = (SpeechClassifiedData)audio;
                    this.sendToQueue(audio);
                    if (!data.isSpeech() || !(speechStarted = this.handleFirstSpeech(data))) continue;
                    this.addSpeechStart();
                    this.inSpeech = true;
                    this.startCountingFrames();
                    continue;
                }
                if (audio instanceof DataStartSignal) {
                    this.reset();
                    this.sendToQueue(audio);
                    continue;
                }
                this.sendToQueue(audio);
                continue;
            }
            if (audio instanceof SpeechClassifiedData) {
                data = (SpeechClassifiedData)audio;
                this.sendToQueue(data);
                if (!data.isSpeech()) {
                    this.inSpeech = !this.readEndFrames(data);
                    continue;
                }
                this.countSpeechFrame();
                continue;
            }
            if (audio instanceof DataEndSignal) {
                this.sendToQueue(new SpeechEndSignal(((Signal)audio).getTime()));
                this.sendToQueue(audio);
                this.inSpeech = false;
                continue;
            }
            if (!(audio instanceof DataStartSignal)) continue;
            this.reset();
            this.sendToQueue(audio);
        }
        if (!this.outputQueue.isEmpty()) {
            audio = this.outputQueue.remove(0);
            if (audio instanceof SpeechClassifiedData) {
                data = (SpeechClassifiedData)audio;
                audio = data.getDoubleData();
            }
            if (audio instanceof DataStartSignal) {
                DataStartSignal.tagAsVadStream((DataStartSignal)audio);
            }
            return audio;
        }
        return null;
    }

    private void countSpeechFrame() {
        ++this.frameCount;
        int minTime = this.speechLeader + this.speechTrailer;
        this.endSilenceTime = (int)((double)this.initialEndSilenceTime - (double)((float)this.initialEndSilenceTime - (float)minTime) / this.endSilenceDecay * ((double)this.frameCount / 100.0));
        if (this.endSilenceTime <= minTime) {
            this.endSilenceTime = minTime;
        }
    }

    private void startCountingFrames() {
        this.frameCount = 0;
        this.endSilenceTime = this.initialEndSilenceTime;
    }

    private Data readData() throws DataProcessingException {
        return this.getPredecessor().getData();
    }

    private void sendToQueue(Data audio) {
        this.outputQueue.add(audio);
    }

    public int getAudioTime(SpeechClassifiedData audio) {
        return (int)((float)audio.getValues().length * 1000.0f / (float)audio.getSampleRate());
    }

    private boolean handleFirstSpeech(SpeechClassifiedData audio) throws DataProcessingException {
        int speechTime = this.getAudioTime(audio);
        while (speechTime < this.startSpeechTime) {
            Data next = this.readData();
            if (next == null) {
                return false;
            }
            this.sendToQueue(next);
            if (!(next instanceof SpeechClassifiedData)) continue;
            if (!((SpeechClassifiedData)next).isSpeech()) {
                return false;
            }
            speechTime += this.getAudioTime(audio);
        }
        return true;
    }

    private void addSpeechStart() {
        long lastCollectTime = 0L;
        int silenceLength = 0;
        int initalSpeechLength = 0;
        ListIterator<Data> i = this.outputQueue.listIterator(this.outputQueue.size());
        while ((silenceLength < this.speechLeader || initalSpeechLength < this.startSpeechTime) && i.hasPrevious()) {
            Data current = i.previous();
            if (current instanceof SpeechClassifiedData) {
                SpeechClassifiedData data = (SpeechClassifiedData)current;
                if (data.isSpeech()) {
                    initalSpeechLength += this.getAudioTime(data);
                } else {
                    silenceLength += this.getAudioTime(data);
                }
                lastCollectTime = data.getCollectTime();
                continue;
            }
            if (current instanceof DataStartSignal || current instanceof SpeechEndSignal) {
                i.next();
                break;
            }
            if (!(current instanceof DataEndSignal)) continue;
            throw new Error("Illegal signal " + current);
        }
        if (this.speechLeader > 0) assert (lastCollectTime != 0L);
        i.add(new SpeechStartSignal(lastCollectTime));
    }

    private boolean readEndFrames(SpeechClassifiedData audio) throws DataProcessingException {
        SpeechClassifiedData data;
        Data next;
        boolean speechEndAdded = false;
        boolean readTrailer = true;
        int originalLast = this.outputQueue.size() - 1;
        int silenceLength = this.getAudioTime(audio);
        while (silenceLength < this.endSilenceTime) {
            next = this.readData();
            if (next instanceof SpeechClassifiedData) {
                data = (SpeechClassifiedData)next;
                this.sendToQueue(data);
                if (data.isSpeech()) {
                    return false;
                }
                silenceLength += this.getAudioTime(data);
                continue;
            }
            if (next instanceof DataEndSignal) {
                this.sendToQueue(next);
                readTrailer = false;
                break;
            }
            if (!(next instanceof Signal)) continue;
            throw new Error("Illegal signal: " + next);
        }
        if (readTrailer) {
            while (!speechEndAdded && silenceLength < this.speechTrailer) {
                next = this.readData();
                if (next instanceof SpeechClassifiedData) {
                    data = (SpeechClassifiedData)next;
                    if (data.isSpeech()) {
                        this.sendToQueue(new SpeechEndSignal(data.getCollectTime()));
                        this.sendToQueue(data);
                        speechEndAdded = true;
                        break;
                    }
                    silenceLength += this.getAudioTime(data);
                    this.sendToQueue(data);
                    continue;
                }
                if (next instanceof DataEndSignal) {
                    this.sendToQueue(new SpeechEndSignal(((Signal)next).getTime()));
                    this.sendToQueue(next);
                    speechEndAdded = true;
                    continue;
                }
                throw new Error("Illegal signal: " + next);
            }
        }
        if (!speechEndAdded) {
            ListIterator<Data> i = this.outputQueue.listIterator(originalLast);
            long nextCollectTime = 0L;
            long lastSampleNumber = 0L;
            silenceLength = 0;
            while (silenceLength < this.speechTrailer && i.hasNext()) {
                Data next2 = i.next();
                if (next2 instanceof DataEndSignal) {
                    i.previous();
                    break;
                }
                if (!(next2 instanceof SpeechClassifiedData)) continue;
                SpeechClassifiedData data2 = (SpeechClassifiedData)next2;
                nextCollectTime = data2.getCollectTime();
                assert (!data2.isSpeech());
                silenceLength += this.getAudioTime(data2);
                lastSampleNumber = data2.getFirstSampleNumber() + (long)data2.getValues().length - 1L;
            }
            if (this.speechTrailer > 0) assert (nextCollectTime != 0L && lastSampleNumber != 0L);
            i.add(new SpeechEndSignal(nextCollectTime));
        }
        return true;
    }

    public boolean inSpeech() {
        return this.inSpeech;
    }
}

