/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.frontend;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.util.machlearn.OVector;

public class DoubleData
extends OVector
implements Data {
    private int sampleRate;
    private long firstSampleNumber;
    private long collectTime;

    public DoubleData(double[] values) {
        super(values);
    }

    public DoubleData(double[] values, int sampleRate, long collectTime, long firstSampleNumber) {
        super(values);
        this.sampleRate = sampleRate;
        this.collectTime = collectTime;
        this.firstSampleNumber = firstSampleNumber;
    }

    @Override
    public String toString() {
        return "DoubleData: " + this.sampleRate + "Hz, first sample #: " + this.firstSampleNumber + ", collect time: " + this.collectTime;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public long getFirstSampleNumber() {
        return this.firstSampleNumber;
    }

    public long getCollectTime() {
        return this.collectTime;
    }

    public DoubleData clone() throws CloneNotSupportedException {
        try {
            DoubleData data = (DoubleData)super.clone();
            data.sampleRate = this.sampleRate;
            data.collectTime = this.collectTime;
            data.firstSampleNumber = this.firstSampleNumber;
            return data;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

