/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.search;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.decoder.search.WordPruningBreadthFirstSearchManager;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SkewPruningSearchManager
extends WordPruningBreadthFirstSearchManager {
    private Logger logger;
    boolean pruneHMM = false;
    int skew = 2;
    private Map<SearchState, Token> skewMap;

    @Override
    protected boolean allowExpansion(Token t) {
        if (this.pruneHMM) {
            return this.skewPruneHMM(t);
        }
        return this.skewPruneWord(t);
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
    }

    @Override
    protected void localStart() {
        this.skewMap = new HashMap<SearchState, Token>();
    }

    private boolean skewPruneHMM(Token t) {
        boolean keep = true;
        SearchState ss = t.getSearchState();
        if (ss instanceof HMMSearchState && !t.isEmitting()) {
            Token lastToken = this.skewMap.get(ss);
            if (lastToken != null) {
                int lastFrame = lastToken.getFrameNumber();
                if (t.getFrameNumber() - lastFrame > this.skew || t.getScore() > lastToken.getScore()) {
                    keep = true;
                } else {
                    this.logger.fine("Dropped " + t + " in favor of " + lastToken);
                    keep = false;
                }
            } else {
                keep = true;
            }
            if (keep) {
                this.skewMap.put(ss, t);
            }
        }
        return keep;
    }

    private boolean skewPruneWord(Token t) {
        boolean keep = true;
        SearchState ss = t.getSearchState();
        if (ss instanceof WordSearchState) {
            Token lastToken = this.skewMap.get(ss);
            if (lastToken != null) {
                int lastFrame = lastToken.getFrameNumber();
                if (t.getFrameNumber() - lastFrame > this.skew || t.getScore() > lastToken.getScore()) {
                    keep = true;
                } else {
                    this.logger.fine("Dropped " + t + " in favor of " + lastToken);
                    keep = false;
                }
            } else {
                keep = true;
            }
            if (keep) {
                this.skewMap.put(ss, t);
            }
        }
        return keep;
    }
}

