/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder.scorer;

import edu.cmu.sphinx.decoder.scorer.ScoreNormalizer;
import edu.cmu.sphinx.decoder.scorer.Scoreable;
import edu.cmu.sphinx.decoder.scorer.SimpleAcousticScorer;
import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.util.CustomThreadFactory;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadedAcousticScorer
extends SimpleAcousticScorer {
    @S4Integer(defaultValue=5)
    public static final String PROP_THREAD_PRIORITY = "threadPriority";
    @S4Integer(defaultValue=0)
    public static final String PROP_NUM_THREADS = "numThreads";
    @S4Boolean(defaultValue=true)
    public static final String PROP_IS_CPU_RELATIVE = "isCpuRelative";
    @S4Integer(defaultValue=10)
    public static final String PROP_MIN_SCOREABLES_PER_THREAD = "minScoreablesPerThread";
    private static final String className = ThreadedAcousticScorer.class.getSimpleName();
    private int numThreads;
    private int threadPriority;
    private int minScoreablesPerThread;
    private ExecutorService executorService;

    public ThreadedAcousticScorer(BaseDataProcessor frontEnd, ScoreNormalizer scoreNormalizer, int minScoreablesPerThread, boolean cpuRelative, int numThreads, int threadPriority) {
        super(frontEnd, scoreNormalizer);
        this.init(minScoreablesPerThread, cpuRelative, numThreads, threadPriority);
    }

    public ThreadedAcousticScorer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.init(ps.getInt(PROP_MIN_SCOREABLES_PER_THREAD), ps.getBoolean(PROP_IS_CPU_RELATIVE), ps.getInt(PROP_NUM_THREADS), ps.getInt(PROP_THREAD_PRIORITY));
    }

    private void init(int minScoreablesPerThread, boolean cpuRelative, int numThreads, int threadPriority) {
        this.minScoreablesPerThread = minScoreablesPerThread;
        if (cpuRelative) {
            numThreads += Runtime.getRuntime().availableProcessors();
        }
        this.numThreads = numThreads;
        this.threadPriority = threadPriority;
    }

    @Override
    public void allocate() {
        super.allocate();
        if (this.executorService == null) {
            if (this.numThreads > 1) {
                this.logger.fine("# of scoring threads: " + this.numThreads);
                this.executorService = Executors.newFixedThreadPool(this.numThreads, new CustomThreadFactory(className, true, this.threadPriority));
            } else {
                this.logger.fine("no scoring threads");
            }
        }
    }

    @Override
    public void deallocate() {
        super.deallocate();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    @Override
    protected <T extends Scoreable> T doScoring(List<T> scoreableList, final Data data) throws Exception {
        int totalSize;
        int jobSize;
        if (this.numThreads > 1 && (jobSize = Math.max(((totalSize = scoreableList.size()) + this.numThreads - 1) / this.numThreads, this.minScoreablesPerThread)) < totalSize) {
            ArrayList<1> tasks = new ArrayList<1>();
            int from = 0;
            int to = jobSize;
            while (from < totalSize) {
                final List<T> scoringJob = scoreableList.subList(from, Math.min(to, totalSize));
                tasks.add(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return ThreadedAcousticScorer.super.doScoring(scoringJob, data);
                    }
                });
                from = to;
                to += jobSize;
            }
            ArrayList finalists = new ArrayList(tasks.size());
            for (Future result : this.executorService.invokeAll(tasks)) {
                finalists.add(result.get());
            }
            if (finalists.size() == 0) {
                throw new DataProcessingException("No scoring jobs ended");
            }
            return (T)Collections.min(finalists, Scoreable.COMPARATOR);
        }
        return super.doScoring(scoreableList, data);
    }
}

