/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.decoder;

import edu.cmu.sphinx.decoder.AbstractDecoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.search.SearchManager;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.util.List;

public class Decoder
extends AbstractDecoder {
    @S4Integer(defaultValue=100000)
    public static final String PROP_FEATURE_BLOCK_SIZE = "featureBlockSize";
    private int featureBlockSize;

    public Decoder() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.featureBlockSize = ps.getInt(PROP_FEATURE_BLOCK_SIZE);
    }

    public Decoder(SearchManager searchManager, boolean fireNonFinalResults, boolean autoAllocate, List<ResultListener> resultListeners, int featureBlockSize) {
        super(searchManager, fireNonFinalResults, autoAllocate, resultListeners);
        this.featureBlockSize = featureBlockSize;
    }

    @Override
    public Result decode(String referenceText) {
        Result result;
        this.searchManager.startRecognition();
        do {
            if ((result = this.searchManager.recognize(this.featureBlockSize)) == null) continue;
            result.setReferenceText(referenceText);
            this.fireResultListeners(result);
        } while (result != null && !result.isFinal());
        this.searchManager.stopRecognition();
        return result;
    }
}

