/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.handler.StreamServerListener;

public class StreamServerHandler
extends SimpleChannelHandler {
    protected final StreamServerListener streamServerListener;
    protected static final Logger logger = LoggerFactory.getLogger(StreamServerHandler.class);

    public StreamServerHandler(StreamServerListener streamServerListener) {
        this.streamServerListener = streamServerListener;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable t = e.getCause();
        logger.debug("exception caught at :{},exception :{}", (Object)channel, (Object)t);
        this.streamServerListener.onExcaption(channel, t);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        logger.info("channel connected :{}", (Object)channel);
        this.streamServerListener.onClientConnectedIn(channel);
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        logger.info("channel disconnected :{}", (Object)channel);
        this.streamServerListener.onClientDisconnected(channel);
        super.channelDisconnected(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        Channel channel = e.getChannel();
        long size = e.getWrittenAmount();
        logger.info("frame send at :{} size :{}", (Object)channel, (Object)size);
        super.writeComplete(ctx, e);
    }
}

