/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.handler.StreamClientListener;
import us.sosia.video.stream.handler.frame.FrameDecoder;

public class StreamClientHandler
extends SimpleChannelHandler {
    protected final StreamClientListener streamClientListener;
    protected static final Logger logger = LoggerFactory.getLogger(StreamClientHandler.class);
    protected final FrameDecoder frameDecoder = new FrameDecoder(4);

    public StreamClientHandler(StreamClientListener streamClientListener) {
        this.streamClientListener = streamClientListener;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable t = e.getCause();
        logger.debug("exception at :{}", (Object)channel);
        this.streamClientListener.onException(channel, t);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        logger.info("channel connected at {}", (Object)channel);
        this.streamClientListener.onConnected(channel);
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        logger.info("channel disconnected at :{}", (Object)channel);
        this.streamClientListener.onDisconnected(channel);
        super.channelDisconnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer channelBuffer = (ChannelBuffer)e.getMessage();
        logger.info("message received :{}", (Object)channelBuffer.readableBytes());
        super.messageReceived(ctx, e);
    }
}

