/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IMetaData;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.handler.ImageUtils;
import us.sosia.video.stream.handler.frame.FrameEncoder;

public class H264StreamEncoder
extends OneToOneEncoder {
    protected static final Logger logger = LoggerFactory.getLogger(Logger.class);
    protected final IStreamCoder iStreamCoder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING, (ICodec.ID)ICodec.ID.CODEC_ID_H264);
    protected final IPacket iPacket = IPacket.make();
    protected long startTime;
    protected final Dimension dimension;
    protected final FrameEncoder frameEncoder;

    public H264StreamEncoder(Dimension dimension, boolean usingInternalFrameEncoder) {
        this.dimension = dimension;
        this.frameEncoder = usingInternalFrameEncoder ? new FrameEncoder(4) : null;
        this.initialize();
    }

    private void initialize() {
        this.iStreamCoder.setNumPicturesInGroupOfPictures(25);
        this.iStreamCoder.setBitRate(200000);
        this.iStreamCoder.setBitRateTolerance(10000);
        this.iStreamCoder.setPixelType(IPixelFormat.Type.YUV420P);
        this.iStreamCoder.setHeight(this.dimension.height);
        this.iStreamCoder.setWidth(this.dimension.width);
        this.iStreamCoder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
        this.iStreamCoder.setGlobalQuality(0);
        IRational rate = IRational.make((int)25, (int)1);
        this.iStreamCoder.setFrameRate(rate);
        this.iStreamCoder.setTimeBase(IRational.make((int)rate.getDenominator(), (int)rate.getNumerator()));
        IMetaData codecOptions = IMetaData.make();
        codecOptions.setValue("tune", "zerolatency");
        int revl = this.iStreamCoder.open(codecOptions, null);
        if (revl < 0) {
            throw new RuntimeException("could not open the coder");
        }
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        return this.encode(msg);
    }

    public Object encode(Object msg) throws Exception {
        if (msg == null) {
            return null;
        }
        if (!(msg instanceof BufferedImage)) {
            throw new IllegalArgumentException("your need to pass into an bufferedimage");
        }
        logger.info("encode the frame");
        BufferedImage bufferedImage = (BufferedImage)msg;
        BufferedImage convetedImage = ImageUtils.convertToType(bufferedImage, 5);
        IConverter converter = ConverterFactory.createConverter((BufferedImage)convetedImage, (IPixelFormat.Type)IPixelFormat.Type.YUV420P);
        long now = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = now;
        }
        IVideoPicture pFrame = converter.toPicture(convetedImage, (now - this.startTime) * 1000L);
        this.iStreamCoder.encodeVideo(this.iPacket, pFrame, 0);
        pFrame.delete();
        converter.delete();
        if (this.iPacket.isComplete()) {
            try {
                ByteBuffer byteBuffer = this.iPacket.getByteBuffer();
                if (this.iPacket.isKeyPacket()) {
                    logger.info("key frame");
                }
                ChannelBuffer channelBuffe = ChannelBuffers.copiedBuffer((ByteBuffer)byteBuffer.order(ByteOrder.BIG_ENDIAN));
                if (this.frameEncoder != null) {
                    ChannelBuffer channelBuffer = this.frameEncoder.encode(channelBuffe);
                    return channelBuffer;
                }
                ChannelBuffer channelBuffer = channelBuffe;
                return channelBuffer;
            }
            finally {
                this.iPacket.reset();
            }
        }
        return null;
    }
}

