/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.handler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.handler.StreamFrameListener;
import us.sosia.video.stream.handler.frame.FrameDecoder;

public class H264StreamDecoder
extends OneToOneDecoder {
    protected static final Logger logger = LoggerFactory.getLogger(H264StreamDecoder.class);
    protected final IStreamCoder iStreamCoder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.DECODING, (ICodec.ID)ICodec.ID.CODEC_ID_H264);
    protected final ConverterFactory.Type type = ConverterFactory.findRegisteredConverter((String)"XUGGLER-BGR-24");
    protected final StreamFrameListener streamFrameListener;
    protected final Dimension dimension;
    protected final FrameDecoder frameDecoder;
    protected final ExecutorService decodeWorker;

    public H264StreamDecoder(StreamFrameListener streamFrameListener, Dimension dimension, boolean internalFrameDecoder, boolean decodeInOtherThread) {
        this.streamFrameListener = streamFrameListener;
        this.dimension = dimension;
        this.frameDecoder = internalFrameDecoder ? new FrameDecoder(4) : null;
        this.decodeWorker = decodeInOtherThread ? Executors.newSingleThreadExecutor() : null;
        this.initialize();
    }

    private void initialize() {
        this.iStreamCoder.open(null, null);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBuffer frameBuffer;
        if (this.decodeWorker != null) {
            this.decodeWorker.execute(new decodeTask(msg));
            return null;
        }
        if (msg == null) {
            throw new NullPointerException("you cannot pass into an null to the decode");
        }
        if (this.frameDecoder != null) {
            frameBuffer = this.frameDecoder.decode((ChannelBuffer)msg);
            if (frameBuffer == null) {
                return null;
            }
        } else {
            frameBuffer = (ChannelBuffer)msg;
        }
        int size = frameBuffer.readableBytes();
        logger.info("decode the frame size :{}", (Object)size);
        IBuffer iBuffer = IBuffer.make(null, (int)size);
        IPacket iPacket = IPacket.make((IBuffer)iBuffer);
        iPacket.getByteBuffer().put(frameBuffer.toByteBuffer());
        if (!iPacket.isComplete()) {
            return null;
        }
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)this.dimension.width, (int)this.dimension.height);
        try {
            int postion = 0;
            int packageSize = iPacket.getSize();
            while (postion < packageSize) {
                IConverter converter;
                if ((postion += this.iStreamCoder.decodeVideo(picture, iPacket, postion)) < 0) {
                    throw new RuntimeException("error  decoding video");
                }
                if (picture.isComplete()) {
                    converter = ConverterFactory.createConverter((String)this.type.getDescriptor(), (IVideoPicture)picture);
                    BufferedImage image = converter.toImage(picture);
                    if (this.streamFrameListener != null) {
                        this.streamFrameListener.onFrameReceived(image);
                    }
                } else {
                    picture.delete();
                    iPacket.delete();
                    return null;
                }
                converter.delete();
                picture.getByteBuffer().clear();
            }
        }
        finally {
            if (picture != null) {
                picture.delete();
            }
            iPacket.delete();
        }
        return null;
    }

    private class decodeTask
    implements Runnable {
        private final Object msg;

        public decodeTask(Object msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            ChannelBuffer frameBuffer;
            block16: {
                if (this.msg == null) {
                    return;
                }
                if (H264StreamDecoder.this.frameDecoder != null) {
                    try {
                        frameBuffer = H264StreamDecoder.this.frameDecoder.decode((ChannelBuffer)this.msg);
                        if (frameBuffer == null) {
                            return;
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                frameBuffer = (ChannelBuffer)this.msg;
            }
            int size = frameBuffer.readableBytes();
            logger.info("decode the frame size :{}", (Object)size);
            IBuffer iBuffer = IBuffer.make(null, (int)size);
            IPacket iPacket = IPacket.make((IBuffer)iBuffer);
            iPacket.getByteBuffer().put(frameBuffer.toByteBuffer());
            if (!iPacket.isComplete()) {
                return;
            }
            IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)H264StreamDecoder.this.dimension.width, (int)H264StreamDecoder.this.dimension.height);
            try {
                int postion = 0;
                int packageSize = iPacket.getSize();
                while (postion < packageSize) {
                    IConverter converter;
                    if ((postion += H264StreamDecoder.this.iStreamCoder.decodeVideo(picture, iPacket, postion)) < 0) {
                        throw new RuntimeException("error  decoding video");
                    }
                    if (picture.isComplete()) {
                        converter = ConverterFactory.createConverter((String)H264StreamDecoder.this.type.getDescriptor(), (IVideoPicture)picture);
                        BufferedImage image = converter.toImage(picture);
                        if (H264StreamDecoder.this.streamFrameListener != null) {
                            H264StreamDecoder.this.streamFrameListener.onFrameReceived(image);
                        }
                    } else {
                        picture.delete();
                        iPacket.delete();
                        return;
                    }
                    converter.delete();
                    picture.getByteBuffer().clear();
                }
            }
            finally {
                if (picture != null) {
                    picture.delete();
                }
                iPacket.delete();
            }
        }
    }
}

