/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.channel;

import java.awt.Dimension;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import us.sosia.video.stream.handler.H264StreamDecoder;
import us.sosia.video.stream.handler.StreamClientHandler;
import us.sosia.video.stream.handler.StreamClientListener;
import us.sosia.video.stream.handler.StreamFrameListener;

public class StreamClientChannelPipelineFactory
implements ChannelPipelineFactory {
    protected final StreamClientListener streamClientListener;
    protected final StreamFrameListener streamFrameListener;
    protected final Dimension dimension;

    public StreamClientChannelPipelineFactory(StreamClientListener streamClientListener, StreamFrameListener streamFrameListener, Dimension dimension) {
        this.streamClientListener = streamClientListener;
        this.streamFrameListener = streamFrameListener;
        this.dimension = dimension;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("stream client handler", (ChannelHandler)new StreamClientHandler(this.streamClientListener));
        pipeline.addLast("frame decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
        pipeline.addLast("stream handler", (ChannelHandler)new H264StreamDecoder(this.streamFrameListener, this.dimension, false, false));
        return pipeline;
    }
}

