/*
 * Decompiled with CFR 0.152.
 */
package us.sosia.video.stream.agent;

import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.sosia.video.stream.agent.IStreamServerAgent;
import us.sosia.video.stream.agent.StreamServer;
import us.sosia.video.stream.channel.StreamServerChannelPipelineFactory;
import us.sosia.video.stream.handler.H264StreamEncoder;
import us.sosia.video.stream.handler.StreamServerListener;

public class StreamServerAgent
implements IStreamServerAgent {
    protected static final Logger logger = LoggerFactory.getLogger(StreamServer.class);
    protected final Webcam webcam;
    protected final Dimension dimension;
    protected final ChannelGroup channelGroup = new DefaultChannelGroup();
    protected final ServerBootstrap serverBootstrap;
    protected final H264StreamEncoder h264StreamEncoder;
    protected volatile boolean isStreaming;
    protected ScheduledExecutorService timeWorker;
    protected ExecutorService encodeWorker;
    protected int FPS = 25;
    protected ScheduledFuture<?> imageGrabTaskFuture;

    public StreamServerAgent(Webcam webcam, Dimension dimension) {
        this.webcam = webcam;
        this.dimension = dimension;
        this.serverBootstrap = new ServerBootstrap();
        this.serverBootstrap.setFactory((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)new StreamServerChannelPipelineFactory(new StreamServerListenerIMPL(), dimension));
        this.timeWorker = new ScheduledThreadPoolExecutor(1);
        this.encodeWorker = Executors.newSingleThreadExecutor();
        this.h264StreamEncoder = new H264StreamEncoder(dimension, false);
    }

    public int getFPS() {
        return this.FPS;
    }

    public void setFPS(int fPS) {
        this.FPS = fPS;
    }

    @Override
    public void start(SocketAddress streamAddress) {
        logger.info("Server started :{}", (Object)streamAddress);
        Channel channel = this.serverBootstrap.bind(streamAddress);
        this.channelGroup.add((Object)channel);
    }

    @Override
    public void stop() {
        logger.info("server is stoping");
        this.channelGroup.close();
        this.timeWorker.shutdown();
        this.encodeWorker.shutdown();
        this.serverBootstrap.releaseExternalResources();
    }

    private class StreamServerListenerIMPL
    implements StreamServerListener {
        protected volatile long frameCount = 0L;

        private StreamServerListenerIMPL() {
        }

        @Override
        public void onClientConnectedIn(Channel channel) {
            StreamServerAgent.this.channelGroup.add((Object)channel);
            if (!StreamServerAgent.this.isStreaming) {
                ImageGrabTask imageGrabTask = new ImageGrabTask();
                ScheduledFuture<?> imageGrabFuture = StreamServerAgent.this.timeWorker.scheduleWithFixedDelay(imageGrabTask, 0L, 1000 / StreamServerAgent.this.FPS, TimeUnit.MILLISECONDS);
                StreamServerAgent.this.imageGrabTaskFuture = imageGrabFuture;
                StreamServerAgent.this.isStreaming = true;
            }
            logger.info("current connected clients :{}", (Object)StreamServerAgent.this.channelGroup.size());
        }

        @Override
        public void onClientDisconnected(Channel channel) {
            StreamServerAgent.this.channelGroup.remove((Object)channel);
            int size = StreamServerAgent.this.channelGroup.size();
            logger.info("current connected clients :{}", (Object)size);
            if (size == 1) {
                StreamServerAgent.this.imageGrabTaskFuture.cancel(false);
                StreamServerAgent.this.webcam.close();
                StreamServerAgent.this.isStreaming = false;
            }
        }

        @Override
        public void onExcaption(Channel channel, Throwable t) {
            StreamServerAgent.this.channelGroup.remove((Object)channel);
            channel.close();
            int size = StreamServerAgent.this.channelGroup.size();
            logger.info("current connected clients :{}", (Object)size);
            if (size == 1) {
                StreamServerAgent.this.imageGrabTaskFuture.cancel(false);
                StreamServerAgent.this.webcam.close();
                StreamServerAgent.this.isStreaming = false;
            }
        }

        private class EncodeTask
        implements Runnable {
            private final BufferedImage image;

            public EncodeTask(BufferedImage image) {
                this.image = image;
            }

            @Override
            public void run() {
                try {
                    Object msg = ((StreamServerListenerIMPL)StreamServerListenerIMPL.this).StreamServerAgent.this.h264StreamEncoder.encode(this.image);
                    if (msg != null) {
                        ((StreamServerListenerIMPL)StreamServerListenerIMPL.this).StreamServerAgent.this.channelGroup.write(msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private class ImageGrabTask
        implements Runnable {
            private ImageGrabTask() {
            }

            @Override
            public void run() {
                logger.info("image grabed ,count :{}", (Object)StreamServerListenerIMPL.this.frameCount++);
                BufferedImage bufferedImage = ((StreamServerListenerIMPL)StreamServerListenerIMPL.this).StreamServerAgent.this.webcam.getImage();
                ((StreamServerListenerIMPL)StreamServerListenerIMPL.this).StreamServerAgent.this.encodeWorker.execute(new EncodeTask(bufferedImage));
            }
        }
    }
}

