/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class JTokeniser
extends marytts.modules.JTokeniser {
    public JTokeniser() {
        super(MaryDataType.RAWMARYXML, MaryDataType.TOKENS, Locale.ENGLISH);
    }

    public MaryData process(MaryData d) throws Exception {
        MaryData result = super.process(d);
        this.normaliseToAscii(result);
        this.propagateForceAccent(result);
        return result;
    }

    protected void normaliseToAscii(MaryData d) {
        Document doc = d.getDocument();
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)ni.nextNode()) != null) {
            String normalised;
            String s = MaryDomUtils.tokenText((Element)t);
            if (s.equals(normalised = MaryUtils.normaliseUnicodeLetters((String)s, (Locale)Locale.ENGLISH))) continue;
            MaryDomUtils.setTokenText((Element)t, (String)normalised);
        }
    }

    protected void propagateForceAccent(MaryData d) {
        Document doc = d.getDocument();
        NodeIterator prosodyNI = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"prosody"}), false);
        Element prosody = null;
        while ((prosody = (Element)prosodyNI.nextNode()) != null) {
            if (!prosody.hasAttribute("force-accent")) continue;
            String forceAccent = prosody.getAttribute("force-accent");
            String accent = null;
            accent = forceAccent.equals("none") ? "none" : "unknown";
            NodeIterator tNI = ((DocumentTraversal)((Object)doc)).createNodeIterator(prosody, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
            Element t = null;
            while ((t = (Element)tNI.nextNode()) != null) {
                if (t.hasAttribute("accent")) continue;
                t.setAttribute("accent", accent);
            }
        }
    }
}

