/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JsonSerializer;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.StatementUpdate;
import org.wikidata.wdtk.wikibaseapi.WbEditEntityAction;
import org.wikidata.wdtk.wikibaseapi.WikibaseDataFetcher;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WikibaseDataEditor {
    static final Logger logger = LoggerFactory.getLogger(WikibaseDataEditor.class);
    final WbEditEntityAction wbEditEntityAction;
    final WikibaseDataFetcher wikibaseDataFetcher;
    final String siteIri;
    boolean editAsBot = false;

    public WikibaseDataEditor(ApiConnection connection, String siteUri) {
        this.wbEditEntityAction = new WbEditEntityAction(connection, siteUri);
        this.wikibaseDataFetcher = new WikibaseDataFetcher(connection, siteUri);
        this.siteIri = siteUri;
    }

    public boolean editAsBot() {
        return this.editAsBot;
    }

    public void setEditAsBot(boolean editAsBot) {
        this.editAsBot = editAsBot;
    }

    public ItemDocument createItemDocument(ItemDocument itemDocument, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString(itemDocument);
        return (ItemDocument)this.wbEditEntityAction.wbEditEntity(null, null, null, "item", data, false, this.editAsBot, 0L, summary);
    }

    public PropertyDocument createPropertyDocument(PropertyDocument propertyDocument, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString(propertyDocument);
        return (PropertyDocument)this.wbEditEntityAction.wbEditEntity(null, null, null, "property", data, false, this.editAsBot, 0L, summary);
    }

    public ItemDocument editItemDocument(ItemDocument itemDocument, boolean clear, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString(itemDocument);
        return (ItemDocument)this.wbEditEntityAction.wbEditEntity(itemDocument.getItemId().getId(), null, null, null, data, clear, this.editAsBot, itemDocument.getRevisionId(), summary);
    }

    public PropertyDocument editPropertyDocument(PropertyDocument propertyDocument, boolean clear, String summary) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString(propertyDocument);
        return (PropertyDocument)this.wbEditEntityAction.wbEditEntity(propertyDocument.getPropertyId().getId(), null, null, null, data, clear, this.editAsBot, propertyDocument.getRevisionId(), summary);
    }

    public ItemDocument updateStatements(ItemIdValue itemIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary);
    }

    public PropertyDocument updateStatements(PropertyIdValue propertyIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        PropertyDocument currentDocument = (PropertyDocument)this.wikibaseDataFetcher.getEntityDocument(propertyIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary);
    }

    public <T extends StatementDocument> T updateStatements(T currentDocument, List<Statement> addStatements, List<Statement> deleteStatements, String summary) throws MediaWikiApiErrorException, IOException {
        StatementUpdate statementUpdate = new StatementUpdate(currentDocument, addStatements, deleteStatements);
        return (T)((StatementDocument)this.wbEditEntityAction.wbEditEntity(currentDocument.getEntityId().getId(), null, null, null, statementUpdate.getJsonUpdateString(), false, this.editAsBot, currentDocument.getRevisionId(), summary));
    }
}

