/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WbGetEntitiesAction {
    static final Logger logger = LoggerFactory.getLogger(WbGetEntitiesAction.class);
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper = new ObjectMapper();

    public WbGetEntitiesAction(ApiConnection connection, String siteUri) {
        this.connection = connection;
        this.siteIri = siteUri;
    }

    public Map<String, EntityDocument> wbGetEntities(WbGetEntitiesActionData properties) throws MediaWikiApiErrorException {
        return this.wbGetEntities(properties.ids, properties.sites, properties.titles, properties.props, properties.languages, properties.sitefilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, EntityDocument> wbGetEntities(String ids, String sites, String titles, String props, String languages, String sitefilter) throws MediaWikiApiErrorException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "wbgetentities");
        if (ids != null) {
            parameters.put("ids", ids);
            if (titles != null) throw new IllegalArgumentException("Cannot use parameters \"sites\" or \"titles\" when using ids to get entity data");
            if (sites != null) {
                throw new IllegalArgumentException("Cannot use parameters \"sites\" or \"titles\" when using ids to get entity data");
            }
        } else {
            if (titles == null) throw new IllegalArgumentException("Either ids, or titles and site must be specified for this action.");
            parameters.put("titles", titles);
            if (sites == null) {
                throw new IllegalArgumentException("Sites parameter is required when using titles parameter to get entity data.");
            }
            parameters.put("sites", sites);
        }
        if (props != null) {
            parameters.put("props", props);
        }
        if (languages != null) {
            parameters.put("languages", languages);
        }
        if (sitefilter != null) {
            parameters.put("sitefilter", sitefilter);
        }
        parameters.put("format", "json");
        try (InputStream response = this.connection.sendRequest("POST", parameters);){
            JsonNode root = this.mapper.readTree(response);
            HashMap<String, EntityDocument> result = new HashMap<String, EntityDocument>();
            this.connection.checkErrors(root);
            this.connection.logWarnings(root);
            JsonNode entities = root.path("entities");
            for (JsonNode entityNode : entities) {
                if (entityNode.has("missing")) continue;
                try {
                    JacksonTermedStatementDocument ed = this.mapper.treeToValue(entityNode, JacksonTermedStatementDocument.class);
                    ed.setSiteIri(this.siteIri);
                    if (titles == null) {
                        result.put(ed.getEntityId().getId(), ed);
                        continue;
                    }
                    if (!(ed instanceof JacksonItemDocument) || !((JacksonItemDocument)ed).getSiteLinks().containsKey(sites)) continue;
                    result.put(((JacksonItemDocument)ed).getSiteLinks().get(sites).getPageTitle(), ed);
                }
                catch (JsonProcessingException e) {
                    logger.error("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString());
                }
            }
            HashMap<String, EntityDocument> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            logger.error("Could not retrive data: " + e.toString());
            return null;
        }
    }
}

