/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.wikidata.wdtk.util.CompressionType;
import org.wikidata.wdtk.util.DirectoryManager;

public class DirectoryManagerImpl
implements DirectoryManager {
    final Path directory;
    final boolean readOnly;

    public DirectoryManagerImpl(Path baseDirectory, Boolean readOnly) throws IOException {
        this.directory = baseDirectory;
        this.readOnly = readOnly;
        this.createDirectory(this.directory);
    }

    public String toString() {
        return this.directory.toString();
    }

    @Override
    public DirectoryManager getSubdirectoryManager(String subdirectoryName) throws IOException {
        return new DirectoryManagerImpl(this.directory.resolve(subdirectoryName), this.readOnly);
    }

    @Override
    public boolean hasSubdirectory(String subdirectoryName) {
        Path subdirectoryPath = this.directory.resolve(subdirectoryName);
        return Files.isDirectory(subdirectoryPath, new LinkOption[0]);
    }

    @Override
    public boolean hasFile(String fileName) {
        Path filePath = this.directory.resolve(fileName);
        return Files.isRegularFile(filePath, new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0]);
    }

    @Override
    public long createFile(String fileName, InputStream inputStream) throws IOException {
        long fileSize;
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
             FileChannel fc = FileChannel.open(filePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            fileSize = fc.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        return fileSize;
    }

    @Override
    public long createFileAtomic(String fileName, InputStream inputStream) throws IOException {
        long fileSize;
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        Path fileTempPath = this.directory.resolve(fileName + ".part");
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
             FileChannel fc = FileChannel.open(fileTempPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            fileSize = fc.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        Files.move(fileTempPath, filePath, new CopyOption[0]);
        return fileSize;
    }

    @Override
    public void createFile(String fileName, String fileContents) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            bufferedWriter.write(fileContents);
        }
    }

    @Override
    public OutputStream getOutputStreamForFile(String fileName) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        return Files.newOutputStream(filePath, new OpenOption[0]);
    }

    @Override
    public InputStream getInputStreamForFile(String fileName, CompressionType compressionType) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        InputStream fileInputStream = Files.newInputStream(filePath, StandardOpenOption.READ);
        return this.getCompressorInputStream(fileInputStream, compressionType);
    }

    protected InputStream getCompressorInputStream(InputStream inputStream, CompressionType compressionType) throws IOException {
        switch (compressionType) {
            case NONE: {
                return inputStream;
            }
            case GZIP: {
                return new GZIPInputStream(inputStream);
            }
            case BZ2: {
                return new BZip2CompressorInputStream(new BufferedInputStream(inputStream));
            }
        }
        throw new IllegalArgumentException("Unsupported compression type: " + (Object)((Object)compressionType));
    }

    @Override
    public List<String> getSubdirectories(String glob) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.directory, glob);){
            for (Path entry : directoryStream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                result.add(entry.getFileName().toString());
            }
        }
        return result;
    }

    void createDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        if (this.readOnly) {
            throw new FileNotFoundException("The requested directory \"" + path.toString() + "\" does not exist and we are in read-only mode, so it cannot be created.");
        }
        Files.createDirectory(path, new FileAttribute[0]);
    }

    void ensureWritePermission(Path writeFilePath) throws IOException {
        if (this.readOnly) {
            throw new IOException("Cannot write to \"" + writeFilePath.toString() + "\" since we are in read-only mode.");
        }
    }
}

